/* =========================== START PROC SS3TAB ======================== */
PROC SS3TAB(DATA,IN,IFRAC) ;
    /*  THIS GIVES A SCALE ESTIMATE  */
    /*  BASED ON THE SMALLEST RAW K - SPACING  */
    /*  OF ENTRIES IN THE VECTOR DATA  */
    /*  USES SIMULATED TRUE VALUES,  */
    /*  FROM A TABLE CONSTRUCTED BY SS2DAT.PRG  */
    /*  SO ONLY VALUES SUPPORTED ARE:  */
    /*  IN = 1,2  FOR N = 100, 1000  */
    /*  IFRAC = 1,2,3,4,5,6  FOR FRAC = .2,.3,.4,.5,.6,.7  */
    /*  REQUIRES FILE SS3DAT.FMT IN CURRENT DIRECTORY  */

  LOCAL NOBS,FRAC,SC,EKG ;

  IF IN == 1 ;
    NOBS = 100 ;
  ELSEIF IN == 2 ;
    NOBS = 1000 ;
  ELSE ;
    RETP(0) ;
  ENDIF ;


  IF SUMC(IFRAC .== SEQA(1,1,6)) ;      /*  IF IFRAC IS ONE OF 1,...,6  */
    FRAC = (IFRAC + 1) / 10 ;
  ELSE ;
    RETP(0) ;
  ENDIF ;

             /*  GET RAW MINIMUM SMOOTHED K-GAP  */
  SC = SS3RAW(DATA,FRAC) ;

             /*  GET EXPECTED N(0,1) MINIMUM SMOOTHED KGAP  */
  LOAD EKG = SS3DAT ;
  EKG = EKG[IN,IFRAC] ;
  SC = SC / EKG ;     /*  ADJUST SO EST. 1 FOR N(0,1)  */

  RETP(SC) ;
ENDP ;
/* ============================ END PROC SS3TAB ======================== */

