/* =========================== START PROC SS4RAW ======================== */
PROC SS4RAW(V,FRAC) ;
    /*  THIS FIND THE SMALLEST STANDARD  */
    /*  DEVITAION OVER K - SPACINGS  */
    /*  OF ENTRIES IN A COLUMN VECTOR V  */
    /*  FRAC IS THE FRACTION OF THE NUMBER OF  */
    /*  OBSERVATIONS IN EACH WINDOW  */

  LOCAL NOBS,K,SV,V1,VSS1,VSS2,VSD ;

  NOBS = ROWS(V) ;
  K = ROUND(FRAC * NOBS) ;    /* NUMBER OF INDICES IN EACH SD */

  SV = SORTC(V,1) ;

            /*  GET THE VECTORS OF WINDOW WISE SUMS OF SQUARES  */
  V1 = ONES(K,1) ;
  VSS1 = CONV(SV,V1,K,NOBS) ;
  SV = SV .* SV ;
  VSS2 = CONV(SV,V1,K,NOBS) ;
  SV = 0 ;

            /*  GET VECTOR OF SD'S  */
  VSD = VSS2 - (VSS1 .* VSS1 ./ K) ;
  VSD = SQRT(VSD ./ (K - 1)) ;

  RETP(MINC(VSD)) ;
ENDP ;
/* ============================ END PROC SS4RAW ======================== */

