/* =========================== START PROC SS5 ======================== */
PROC SS5(SDATA,FRAC) ;
    /*  THIS GIVES A SCALE ESTIMATE  */
    /*  BASED ON THE SMALLEST RAW K - SPACING  */
    /*  OF ENTRIES IN THE VECTOR DATA  */
    /*  !!!   ASSUMED TO BE sorted     !!!      */
    /*  IMPROVES SS3 BY USING A 3RD DIFFERENCE SCHEME  */
    /*  FRAC IS THE FRACTION OF DATA IN EACH WINDOW  */

  LOCAL NOBS,BETA,K,VKG,ICENT,D1,EKG,SS3,
                PHI0,CFRAC,GAM,TAU,KAP,COEFF,D3,W1,SS5 ;

  NOBS = ROWS(SDATA) ;
  BETA = FRAC / 2 ;

            /*  GET THE K-GAPS, AND RAW MINIMUM SMOOTHED K-GAP,
                                                   AS IN SS3.G  */
  K = ROUND(FRAC * (NOBS - 1)) ;       /* NUMBER OF INDICES ACROSS THE GAP */
  VKG = SDATA[(K+1):NOBS,1] - SDATA[1:(NOBS-K),1] ;
  ICENT = MININDC(VKG) ;
  D1 = VKG[ICENT,1] ;

             /*  APPROXIMATE N(0,1) MINIMUM KGAP, AS IN SS3.G   */
  EKG = 2 * PHIINV((1 + FRAC) / 2) ;
  EKG = EKG  -  4^(-.875) * (NOBS / 25)^(-2/3) ;
  SS3 = D1 / EKG ;     /*  ADJUST SO EST. 1 FOR N(0,1)  */


            /*  ADJUST D1 TO ACCOUNT FOR MINIMIZING KGAP  */
    PHI0 = 1 / SQRT(2 * PI) ;
  D1 = SS3 * 2 * BETA / PHI0 ;

            /*  INDEX, AND CORRESPONDING FRACTION OF THE DATA,
                           INDICATING CENTERPOINT FOR TALLEST PEAK  */
  ICENT = ICENT + K / 2 ;
  CFRAC = (ICENT - 1) / (NOBS - 1) ;

            /*  CALCULATE D3  */
    GAM = BETA ;
    TAU = BETA ;
    KAP = .001934 + .2832 * BETA + .3803 * BETA^2 - 1.542 * BETA^3 ;
    COEFF = (BETA + GAM) / (TAU + KAP) ;
  D3 = SSD3RAW(SDATA,BETA,GAM,TAU,KAP,COEFF,CFRAC) ;

             /*  ESTIMATE W1, AND SS5  */
  IF  D3 > 0 ;     /*  IF SOME CHANCE FOR IMPROVEMENT  */
    W1 = SQRT(D1 / (3 * D3)) ;
    W1 = 2 * BETA * W1 / (3 * PHI0) ;
    W1 = MINC(W1|1) ;       /*  W1 > 1 WILL GIVE CRAZY ANSWERS  */
    W1 = MAXC(W1|2*BETA) ;  /*  W1 < 2 * BETA  IS INCONSISTENT WITH THEORY  */
    SS5 = W1^(4/5) * SS3 ;
    IF W1 == 2 * BETA ;      /*  GIVE VALUE FOR EASIER DIAGNOSTICS  */
      W1 = 0 ;
    ENDIF ;
  ELSE ;           /*  THEORY HERE CLEARLY NOT WORKING FOR THESE DATA  */
    W1 = -1 ;
    SS5 = SS3 ;
  ENDIF ;

  RETP(SS5|W1) ;
ENDP ;
/* ============================ END PROC SS5 ======================== */
