/* =========================== START PROC SS5TAB ======================== */
PROC SS5TAB(SDATA,IN,IFRAC) ;
    /*  THIS IS A SCALE ESTIMATE INTENDED TO IMPROVE SS3TAB,  */
    /*  BY ESTIMATING THE MASS OF THE BIGGEST PEAK,  */
    /*  USING THE THIRD DIFFERENCE, SSD3RAW    */
    /*  SDATA IS sorted DATA VECTOR  */
    /*  USES SIMULATED TRUE VALUES,  */
    /*  FROM A TABLE CONSTRUCTED BY SS2DAT.PRG  */
    /*  SO ONLY VALUES SUPPORTED ARE:  */
    /*  IN = 1,2  FOR N = 100, 1000  */
    /*  IFRAC = 1,2,3,4,5,6  FOR FRAC = .2,.3,.4,.5,.6,.7  */
    /*  REQUIRES FILE SS3DAT.FMT IN CURRENT DIRECTORY  */
    /*  RETURNS SS5, TOGETHER WITH W1 FOR DIAGNOSTIC USE:  */
    /*      W1 = 1   MEANS ESTIMATE TOO BIG  */
    /*          0   MEANS ESTIMATE TOO SMALL  */
    /*          -1  MEANS NO HOPE, SINCE D3 < 0  */


  LOCAL NOBS,FRAC,BETA,K,VKG,ICENT,D1,EKG,SS3,PHI0,CFRAC,
             GAM,TAU,KAP,COEFF,D3,W1   ,SS5 ;

  IF IN == 1 ;
    NOBS = 100 ;
  ELSEIF IN == 2 ;
    NOBS = 1000 ;
  ELSE ;
    RETP(0) ;
  ENDIF ;

  IF SUMC(IFRAC .== SEQA(1,1,6)) ;      /*  IF IFRAC IS ONE OF 1,...,6  */
    FRAC = (IFRAC + 1) / 10 ;
  ELSE ;
    RETP(0) ;
  ENDIF ;
  BETA = FRAC / 2 ;

  K = ROUND(FRAC * NOBS) ;    /* NUMBER OF INDICES ACROSS THE GAP */

            /*  GET THE K-GAPS, AND RAW MINIMUM SMOOTHED K-GAP,
                                                   AS IN SS3RAW.G  */
  VKG = SDATA[(K+1):NOBS,1] - SDATA[1:(NOBS-K),1] ;
  ICENT = MININDC(VKG) ;
  D1 = VKG[ICENT,1] ;

             /*  GET EXPECTED N(0,1) MINIMUM SMOOTHED KGAP,
                                     AND FORM SS3, AS IN SS3TAB.G  */
  LOAD EKG = SS3DAT ;
  EKG = EKG[IN,IFRAC] ;
  SS3 = D1 / EKG ;     /*  ADJUST SO EST. 1 FOR N(0,1)  */

            /*  ADJUST D1 TO ACCOUNT FOR MINIMIZING KGAP  */
    PHI0 = 1 / SQRT(2 * PI) ;
  D1 = SS3 * 2 * BETA / PHI0 ;

            /*  INDEX, AND CORRESPONDING FRACTION OF THE DATA,
                           INDICATING CENTERPOINT FOR TALLEST PEAK  */
  ICENT = ICENT + K / 2 ;
  CFRAC = (ICENT - 1) / (NOBS - 1) ;

            /*  CALCULATE D3  */
    GAM = BETA ;
    TAU = BETA ;
    KAP = .03278|.04792|.06123|.07238|.07987|.08095 ;
    KAP = KAP[IFRAC,1] ;
    COEFF = (BETA + GAM) / (TAU + KAP) ;
  D3 = SSD3RAW(SDATA,BETA,GAM,TAU,KAP,COEFF,CFRAC) ;

             /*  ESTIMATE W1, AND SS5  */
  IF  D3 > 0 ;     /*  IF SOME CHANCE FOR IMPROVEMENT  */
    W1 = SQRT(D1 / (3 * D3)) ;
    W1 = 2 * BETA * W1 / (3 * PHI0) ;
    W1 = MINC(W1|1) ;       /*  W1 > 1 WILL GIVE CRAZY ANSWERS  */
    W1 = MAXC(W1|2*BETA) ;  /*  W1 < 2 * BETA  IS INCONSISTENT WITH THEORY  */
    SS5 = W1^(4/5) * SS3 ;
    IF W1 == 2 * BETA ;      /*  GIVE VALUE FOR EASIER DIAGNOSTICS  */
      W1 = 0 ;
    ENDIF ;
  ELSE ;           /*  THEORY HERE CLEARLY NOT WORKING FOR THESE DATA  */
    W1 = -1 ;
    SS5 = SS3 ;
  ENDIF ;

  RETP(SS5|W1) ;
ENDP ;
/* ============================ END PROC SS5TAB ======================== */
