/* =========================== START PROC SS7 ======================== */
PROC SS7(SDATA,FRAC) ;
    /*  THIS GIVES A SCALE ESTIMATE  */
    /*  BASED ON THE SMALLEST RAW K - SPACING  */
    /*  OF ENTRIES IN THE VECTOR DATA  */
    /*  !!!   ASSUMED TO BE sorted     !!!      */
    /*  CORRECTS PROC SS5, TO FOMULA IN THE JMVS PAPER   */
    /*  FRAC IS THE FRACTION OF DATA IN EACH WINDOW  */

  LOCAL NOBS,BETA,K,VKG,ICENT,RD1,EKG,SS3,
                PHI02,CFRAC,GAM,TAU,KAP,COEFF,RSD3,C1,C2,W1,SS7 ;

  NOBS = ROWS(SDATA) ;
  BETA = FRAC / 2 ;

            /*  GET THE K-GAPS, AND RAW MINIMUM SMOOTHED K-GAP,
                                                   AS IN SS3.G  */
  K = ROUND(FRAC * (NOBS - 1)) ;       /* NUMBER OF INDICES ACROSS THE GAP */
  VKG = SDATA[(K+1):NOBS,1] - SDATA[1:(NOBS-K),1] ;
  ICENT = MININDC(VKG) ;
  RD1 = VKG[ICENT,1] ;

             /*  APPROXIMATE N(0,1) MINIMUM KGAP, AS IN SS3.G   */
  EKG = 2 * PHIINV((1 + FRAC) / 2) ;
  EKG = EKG  -  4^(-.875) * (NOBS / 25)^(-2/3) ;
  SS3 = RD1 / EKG ;     /*  ADJUST SO EST. 1 FOR N(0,1)  */
       /*  NOTE SS3 HERE IS D1 IN THE PAPER  */


            /*  INDEX, AND CORRESPONDING FRACTION OF THE DATA,
                           INDICATING CENTERPOINT FOR TALLEST PEAK  */
  ICENT = ICENT + K / 2 ;
  CFRAC = (ICENT - 1) / (NOBS - 1) ;

            /*  CALCULATE RSD3  */
    GAM = BETA ;
    TAU = BETA ;
    KAP = .001934 + .2832 * BETA + .3803 * BETA^2 - 1.542 * BETA^3 ;
    COEFF = (BETA + GAM) / (TAU + KAP) ;
  RSD3 = SSD3RAW(SDATA,BETA,GAM,TAU,KAP,COEFF,CFRAC) ;

             /*  ESTIMATE W1, AND SS7  */
  IF  RSD3 > 0 ;     /*  IF SOME CHANCE FOR IMPROVEMENT  */
      C1 = (BETA + GAM) / (2 * BETA) ;
      C2 = (TAU + KAP) / (2 * BETA) ;
    W1 = BETA^2 * C1 * (C1^2 - C2^2) * RD1 ;
      PHI02 = 1 / (2 * PI) ;        /*  PHI(0^2)  */
    W1 = W1 / (6 * PHI02 * RSD3) ;
    W1 = SQRT(W1) ;

    W1 = MINC(W1|1) ;       /*  W1 > 1 WILL GIVE CRAZY ANSWERS  */
    W1 = MAXC(W1|2*BETA) ;  /*  W1 < 2 * BETA  IS INCONSISTENT WITH THEORY  */
    SS7 = W1^(4/5) * SS3 ;
    IF W1 == 2 * BETA ;      /*  GIVE VALUE FOR EASIER DIAGNOSTICS  */
      W1 = 0 ;
    ENDIF ;
  ELSE ;           /*  THEORY HERE CLEARLY NOT WORKING FOR THESE DATA  */
    W1 = -1 ;
    SS7 = SS3 ;
  ENDIF ;

  RETP(SS7|W1) ;
ENDP ;
/* ============================ END PROC SS7 ======================== */
