/* =========================== START PROC SSAGK ======================== */
PROC SSAGK(DATA,P,TFLAG) ;
    /*  SUPER SCALE MEASURE BASED ON AGK,      */
    /*  BASED ON BOTH:   */
    /*    (1)   AVERAGE ABSOLUTE PAIRWISE DIFFERENCES    */
    /*    (2)   ROOT TRIMMED AVERAGE SQUARED PAIRWISE DIFFERENCES,  */
    /*  ASSUMING NORMAL(0,1) DATA    */
    /*  P IS THE PROPORTION OF TRIMMING, ALLOWED TO BE A VECTOR  */
    /*  FOR TFLAG = :   */
    /*     1,  RETURNS  (1)   */
    /*     2,  RETURNS  (2)   */
    /*     3,  RETURNS  (1)~(2)   */

  LOCAL NP,NOBS,NOFP,D1,D2,MAGK,IP,TAGK ;

  NP = ROWS(P) ;
  NOBS = ROWS(DATA) ;
  NOFP = ROUND(P .* NOBS .* (NOBS - 1) ./ 2) ;


  D1 = DATA - DATA' ;              /*  FULL MATRIX OF DIFFERENCES  */
  D1 = D1[2:NOBS,1:(NOBS-1)] ;    /*  MAIN LOWER LEFT BLOCK  */
  D1 = VECH(D1) ;
  D1 = ABS(D1) ;
  D1 = SORTC(D1,1) ;
  D1 = D1[1:MAXC(NOFP)] ;         /*  ONLY KEEP ONES WILL NEED  */

  IF TFLAG == 1 OR TFLAG == 3 ;
    D2 = D1 .* D1 ;
  ENDIF ;

  IF TFLAG == 3 ;
    MAGK = ZEROS(NP,2) ;
  ELSE ;
    MAGK = ZEROS(NP,1) ;
  ENDIF ;

  IP = 1 ;
  DO WHILE IP <= NP ;

    IF TFLAG == 1 OR TFLAG == 3 ;
      MAGK[IP,1] = MEANC(D1[1:NOFP[IP]]) ;
    ENDIF ;

    IF TFLAG == 2 OR TFLAG == 3 ;
      MAGK[IP,COLS(MAGK)] = SQRT(MEANC(D2[1:NOFP[IP]]) / 2) ;
    ENDIF ;

    IP = IP + 1 ;
  ENDO ;

  TAGK = SSTAGK(P,TFLAG) ;
  MAGK = MAGK ./ TAGK ;
        /*  NORMALIZE BY DIVIDING BY N(0,1) ASYMPTOTIC VERSION  */

  RETP(MAGK) ;
ENDP ;
/* ============================ END PROC SSAGK ========================= */
