/* =========================== START PROC SSBAGK ======================== */
PROC SSBAGK(DIFWTS,LEFT,RIGHT,P,TFLAG) ;
    /*  BINNED VERSION OF THE SUPER SCALE MEASURE BASED ON AGK,      */
    /*  BASED ON BOTH:   */
    /*    (1)   AVERAGE ABSOLUTE PAIRWISE DIFFERENCES    */
    /*    (2)   ROOT TRIMMED AVERAGE SQUARED PAIRWISE DIFFERENCES,  */
    /*  ASSUMING NORMAL(0,1) DATA    */
    /*  DIFWTS IS OUTPUT FROM NMDW.G   */
    /*     COUNTS OF COMMON VALUES FROM MATRIX OF ABSOLUTE DIFFERENCES  */
    /*  LEFT IS LEFT ENDPOINT OF BINNING GRID  */
    /*  RIGHT IS RIGHT ENDPOINT OF BINNING GRID  */
    /*  P IS THE PROPORTION OF TRIMMING, ALLOWED TO BE A VECTOR  */
    /*  FOR TFLAG = :   */
    /*     1,  RETURNS  (1)   */
    /*     2,  RETURNS  (2)   */
    /*     3,  RETURNS  (1)~(2)   */

  LOCAL NP,NBIN,NOBS,NOFP,BINWIDTH,DW,CDW,VDEL,VDEL2,MAGK,IP,ICUT,TDW,TAGK ;

  NP = ROWS(P) ;
  NBIN = ROWS(DIFWTS) ;
  NOBS = SQRT(SUMC(DIFWTS)) ;
  NOFP = ROUND(P .* NOBS .* (NOBS - 1) ./ 2) ;
  BINWIDTH = (RIGHT - LEFT) / (NBIN - 1) ;

      /*  PUT IN FORM OF "DIAGONALS OUT", AND "LOWER HALF ONLY"  */
  DW = DIFWTS ;
  DW[1] = DW[1] - NOBS ;
  DW[2:NBIN] = DW[2:NBIN] / 2 ;

  CDW = CUMSUMC(DW) ;     /*  CUMULATIVE VERSION FOR DETERMINING CUTOFFS  */
  VDEL = SEQA(0,BINWIDTH,NBIN) ;
  IF TFLAG > 1 ;
    VDEL2 = VDEL .* VDEL ;
  ENDIF ;

  IF TFLAG == 3 ;
    MAGK = ZEROS(NP,2) ;
  ELSE ;
    MAGK = ZEROS(NP,1) ;
  ENDIF ;

  IP = 1 ;
  DO WHILE IP <= NP ;

    ICUT = MAXINDC(CDW .>= NOFP[IP]) ;
           /*   FIRST INDEX WHERE CUMULATIVE SUM EXCEEDS NUMBER OF TERMS  */
    IF ICUT == 1 ;
      TDW = DW ;
      ICUT = NBIN ;
    ELSE ;
      TDW = DW[1:ICUT] ;
      TDW[ICUT] = NOFP[IP] - CDW[ICUT-1] ;
               /*  READJUST SO NOW HAVE EXACTLY NOFP TERMS  */
    ENDIF ;


    IF TFLAG == 1 OR TFLAG == 3 ;
      MAGK[IP,1] = (TDW' * VDEL[1:ICUT]) ./ NOFP[IP] ;
    ENDIF ;

    IF TFLAG == 2 OR TFLAG == 3 ;
      MAGK[IP,COLS(MAGK)] = SQRT((TDW' * VDEL2[1:ICUT]) ./ (2 * NOFP[IP])) ;
    ENDIF ;

    IP = IP + 1 ;
  ENDO ;

  TAGK = SSTAGK(P,TFLAG) ;
  MAGK = MAGK ./ TAGK ;
        /*  NORMALIZE BY DIVIDING BY N(0,1) ASYMPTOTIC VERSION  */

  RETP(MAGK) ;
ENDP ;
/* ============================ END PROC SSBAGK ========================= */
