/* =========================== START PROC SSD3RAW ======================== */
PROC SSD3RAW(SDATA,BETA,GAM,TAU,KAP,COEFF,CFRAC) ;
    /*  THIS FINDS THE CENTERED SMOOTHED THIRD DIFFERENCE  */
    /*  OF ENTRIES IN A SORTED DATA VECTOR, SDATA  */
    /*  THE DIFFERENCE IS OF THE FORM                */
    /*             X1 - COEFF*X2 + COEFF*X3 - X4  */
    /*  WHERE:                                         */
    /*      X1 IS AVG OF DATA IN THE [CFRAC - BETA, CFRAC - GAM] WINDOW  */
    /*      X2 IS AVG OF DATA IN THE [CFRAC - TAU, CFRAC - KAP] WINDOW  */
    /*      X3 IS AVG OF DATA IN THE [CFRAC + KAP, CFRAC + TAU] WINDOW  */
    /*      X4 IS AVG OF DATA IN THE [CFRAC + GAM, CFRAC + BETA] WINDOW  */
    /*  SO CFRAC SAYS WHERE TO CENTER AS A FRACTION OF THE DATA  */
    /*  2 * BETA IS THE FRACTION OF THE NUMBER OF  */
    /*       OBSERVATIONS IN THE TOTAL WINDOW  */

  LOCAL NOBS,IS,IE,D3 ;

  NOBS = ROWS(SDATA) ;

    IS = ROUND(1 + (NOBS - 1) * (CFRAC + GAM)) ;
    IE = ROUND(1 + (NOBS - 1) * (CFRAC + BETA)) ;
  D3 = MEANC(SDATA[IS:IE,1]) ;

    IS = ROUND(1 + (NOBS - 1) * (CFRAC + KAP)) ;
    IE = ROUND(1 + (NOBS - 1) * (CFRAC + TAU)) ;
  D3 = D3 - COEFF * MEANC(SDATA[IS:IE,1]) ;

    IS = ROUND(1 + (NOBS - 1) * (CFRAC - TAU)) ;
    IE = ROUND(1 + (NOBS - 1) * (CFRAC - KAP)) ;
  D3 = D3 + COEFF * MEANC(SDATA[IS:IE,1]) ;

    IS = ROUND(1 + (NOBS - 1) * (CFRAC - BETA)) ;
    IE = ROUND(1 + (NOBS - 1) * (CFRAC - GAM)) ;
  D3 = D3 - MEANC(SDATA[IS:IE,1]) ;


  RETP(D3) ;
ENDP ;
/* ============================ END PROC SSD3RAW ======================== */
