/* =========================== START PROC SSTAGK ======================== */
PROC SSTAGK(P,TFLAG) ;
    /*  ASYMPTOTIC VERSION OF THE SCALE MEASURE AGK,      */
    /*  BASED ON BOTH:   */
    /*    (1)   AVERAGE ABSOLUTE PAIRWISE DIFFERENCES    */
    /*    (2)   ROOT TRIMMED AVERAGE SQUARED PAIRWISE DIFFERENCES,  */
    /*  ASSUMING NORMAL(0,1) DATA    */
    /*  P IS THE PROPORTION OF TRIMMING, ALLOWED TO BE A VECTOR  */
    /*  FOR TFLAG = :   */
    /*     1,  RETURNS  (1)   */
    /*     2,  RETURNS  (2)   */
    /*     3,  RETURNS  (1)~(2)   */

  LOCAL W,W2O4,MTAGK,TAGK ;

  W = (1 + P) ./ 2 ;
  W = SQRT(2) .* PHIINV3(W,3) ;
  W2O4 = W .* W ./ 4 ;

  IF TFLAG == 3 ;
    MTAGK = ZEROS(ROWS(P),2) ;
  ELSE ;
    MTAGK = ZEROS(ROWS(P),1) ;
  ENDIF ;

  IF TFLAG == 1 OR TFLAG == 3 ;
    TAGK = 1 - EXP(-W2O4) ;
    TAGK = 2 .* TAGK ./ (P .* SQRT(PI)) ;

    MTAGK[.,1] = TAGK ;
  ENDIF ;

  IF TFLAG == 2 OR TFLAG == 3 ;
    TAGK = W .* EXP(-W2O4) ./ (P .* SQRT(PI)) ;
    TAGK = SQRT(1 - TAGK) ;

    MTAGK[.,COLS(MTAGK)] = TAGK ;
  ENDIF ;

  RETP(MTAGK) ;
ENDP ;
/* ============================ END PROC SSTAGK ========================= */
