/* ==================== START PROCEDURE TRBLBIN.PRC ===================== */
PROC (1)=TRBLBIN(INCTS,INCEN,A,B,NBIN) ;
       /*  A IS LEFT BIN CENTER, B IS RIGHT BIN CENTER  */
       /*  THIS MODIFIES TRLBIN BY ALLOWING THE INPUT TO BE BINNED DATA  */
       /*  INCTS ARE INCOMING COUNTS, INCEN IS INCOMING VECTOR OF BIN 
                  CENTERS, NOT NECESSARILY EQUALLY SPACED   */
 LOCAL NINBIN,INC,SINCEN,IGAP,WT,OUTCTS,IINBIN,CT,IG ;
 NINBIN = ROWS(INCTS) ;

 INC = (B - A) / (NBIN - 1) ;
 SINCEN = NBIN * (INCEN - (A - INC)) / (B - (A - INC)) ;
           /*  PUTS INCEN ON SCALE WHERE A = 1 AND B = NBIN  */
 IGAP = FLOOR(SINCEN) ; /*  INDEXES GAP BETWEEN BIN CENTERS WHERE OBS LIES */
 WT = SINCEN - IGAP ;   /*  DISTANCE FROM INCEN TO LEFT OUTCENTER */

 OUTCTS = ZEROS(NBIN,1) ;
 IINBIN = 1 ;
 DO WHILE IINBIN <= NINBIN ;
  IF FLOOR(IINBIN/50) == IINBIN/50 ; "WORKING ON BIN " IINBIN ; ENDIF ;
  CT = INCTS[IINBIN,1] ;
  IG = IGAP[IINBIN,1] ;
  IF IG <= 0 ;
    OUTCTS[1,1] = OUTCTS[1,1] + CT ;
  ELSEIF IG >= NBIN ;
    OUTCTS[NBIN,1] = OUTCTS[NBIN,1] + CT ;
  ELSE ;
    OUTCTS[IG,1] = OUTCTS[IG,1] + (1-WT[IINBIN,1]) * CT ;
    OUTCTS[IG+1,1] = OUTCTS[IG+1,1] + WT[IINBIN,1] * CT ;
  ENDIF ;
  IINBIN = IINBIN + 1 ;
 ENDO ;

 RETP(OUTCTS) ;
ENDP;
/* ====================== END PROCEDURE TRBLBIN.PRG ====================== */
