/* ==================== START PROCEDURE TRLINT.G ===================== */
PROC (1)=TRLINT(FX,X,Y) ;
       /*  FX IS VECTOR OF FUNCTION VALUES ON THE (ORDERED) GRID X,
           Y IS A NEW VECTOR OF ARGUMENTS,
           RETURNS LINEARLY INTERPOLATED VECTOR F(Y)  */
 LOCAL NX,NY,IY,FY,IX,WT ;

 NX = ROWS(X) ;
 NY = ROWS(Y) ;

 FY = ZEROS(NY,1) ;
 IY = 1 ;
 IX = 0 ;
 DO WHILE IY <= NY ;
  IF FLOOR(IY/50) == IY/50 ; "WORKING ON IY " IY ; ENDIF ;

  IF Y[IY,1] <= X[1,1] ;
    FY[IY,1] = FX[1,1] ;
  ELSEIF Y[IY,1] >= X[NX,1] ;
    FY[IY,1] = FX[NX,1] ;
  ELSE ;
/*
    IX = MAXINDC(Y[IY,1] .< X) ;   /*  INDEX OF X NEXT UP FROM Y(IY)  */
*/
    DO UNTIL (Y[IY,1] < X[IX,1]) ;
      IX = IX + 1 ;
    ENDO ;                       /* IX IS INDEX OF X NEXT UP FROM Y(IY)  */

    WT = (X[IX,1] - Y[IY,1]) / (X[IX,1] - X[(IX-1),1]) ;
    FY[IY,1] = WT * FX[(IX-1),1] + (1 - WT) * FX[IX,1] ;
  ENDIF ;
  IY = IY + 1 ;
 ENDO ;

 RETP(FY) ;
ENDP;
/* ====================== END PROCEDURE TRLINT.G ====================== */


