/* =========================== START PROC VDIND ======================== */
PROC (1) = VDIND(XGRID,V1,V2,ISCALE) ;
    /*  FOR EACH POINT IN XGRID~V1,  */
    /*  FINDS THE MEMBER OF XGRID~V2 THAT IS CLOSEST,  */
    /*  IN EUCLIDEAN R2 DISTANCE,   */
    /*  RETURNS THE VECTOR OF INDICES OF CLOSEST ELEMENTS  */
    /*  FOR NICE PICTURE, USE ARROWS STARTING AT XGRID~V1  */
    /*  AND ENDING AT XGRID[VIND]~V2[VIND]   */
    /*  ISCALE = 0  FOR USING DISTANCE BASED ON RAW X AND Y VALUES  */
    /*         = 1  FOR USING DISTANCE BASED ON X AND Y MAPPED TO   */
    /*                      [0,1], ASSUMING X MIN = 0 AS IN K.D.E.  */
    /*         = 2  FOR USING DISTANCE BASED ON X AND Y MAPPED TO   */
    /*                    [0,1], NO RESTRICTIONS, AS IN REGRESSION  */

 LOCAL DENOM,X,MI,M1,M2,MDX,MDY,MD,VIND ;

 X = XGRID ;
 M1 = V1 ;
 M2 = V2 ;

 /*  RESCALE X'S TO [0,1]  */
 IF ISCALE /= 0 ;
   DENOM = MAXC(XGRID) - MINC(XGRID) ;
   IF DENOM /= 0 ;
     X = (XGRID - MINC(XGRID)) ./ DENOM ;
   ENDIF ;
 ENDIF ;

 /*  RESCALE V'S TO [0,1]  */
 IF ISCALE == 1 ;
   DENOM = MAXC(MAXC(V1~V2)) - 0 ;
   IF DENOM /= 0 ;
     M1 = V1 ./ DENOM ;
     M2 = V2 ./ DENOM ;
   ENDIF ;
 ELSEIF ISCALE == 2 ;
   MI = MINC(MINC(M1~M2)) ;
   DENOM = MAXC(MAXC(M1~M2)) - MI ;
   IF DENOM /= 0 ;
     M1 = (V1 - MI) ./ DENOM ;
     M2 = (V2 - MI) ./ DENOM ;
   ENDIF ;
 ENDIF ;

 MDX = X' - X ;
 MDX = MDX .* MDX ;
 MDY = M1' - M2 ;
 MDY = MDY .* MDY ;

 MD = MDX + MDY ;

 VIND = MININDC(MD) ;

 RETP(VIND) ;
ENDP ;
/* ============================ END PROC VDIND ======================== */
