/* =========================== START PROC VDIST1S ======================== */
PROC (1) = VDIST1S(XGRID,V1,V2,ISCALE,INORM) ;
    /*  A "SLOW" VERSION OF VDIST1.G, WHICH DOES THE SAME THING BY A  */
    /*  LOOP, TO HANDLE LARGER VECTORS V1 AND V2  */
    /*  FOR EACH POINT IN XGRID~V1,  */
    /*  FINDS THE MEMBER OF XGRID~V2 THAT IS CLOSEST,  */
    /*  IN EUCLIDEAN R2 DISTANCE,   */
    /*  RETURNS THE "DISTANCE MEASURE":  */
    /*     L1 NORM,   WHEN INORM = 1 ;   */
    /*     L2 NORM,   WHEN INORM = 2 ;   */
    /*    SUP NORM,   WHEN INORM = 3 ;   */
    /*       ALL 3,   WHEN INROM = 0 ;   */
    /*  ISCALE = 0  FOR USING DISTANCE BASED ON RAW X AND Y VALUES  */
    /*         = 1  FOR USING DISTANCE BASED ON X AND Y MAPPED TO   */
    /*                      [0,1], ASSUMING X MIN = 0 AS IN K.D.E.  */
    /*         = 2  FOR USING DISTANCE BASED ON X AND Y MAPPED TO   */
    /*                    [0,1], NO RESTRICTIONS, AS IN REGRESSION  */

 LOCAL N,DENOM,X,MI,M1,M2,I,DX,DY,D,MD,DEL,DIST ;

 N = ROWS(XGRID) ;
 X = XGRID ;
 M1 = V1 ;
 M2 = V2 ;

 /*  RESCALE X'S TO [0,1]  */
 IF ISCALE /= 0 ;
   DENOM = MAXC(XGRID) - MINC(XGRID) ;
   IF DENOM /= 0 ;
     X = (XGRID - MINC(XGRID)) ./ DENOM ;
   ENDIF ;
 ENDIF ;

 /*  RESCALE V'S TO [0,1]  */
 IF ISCALE == 1 ;
   DENOM = MAXC(MAXC(V1~V2)) - 0 ;
   IF DENOM /= 0 ;
     M1 = V1 ./ DENOM ;
     M2 = V2 ./ DENOM ;
   ENDIF ;
 ELSEIF ISCALE == 2 ;
   MI = MINC(MINC(M1~M2)) ;
   DENOM = MAXC(MAXC(M1~M2)) - MI ;
   IF DENOM /= 0 ;
     M1 = (V1 - MI) ./ DENOM ;
     M2 = (V2 - MI) ./ DENOM ;
   ENDIF ;
 ENDIF ;

 MD = ZEROS(N,1) ;
 I = 1 ;
 DO WHILE I <= N ;
/*
   "." ;;
*/

   DX = X[I] - X ;
   DX = DX .* DX ;
   DY = M1[I] - M2 ;
   DY = DY .* DY ;

   D = DX + DY ;
   MD[I] = MINC(D) ;

   I = I + 1 ;
 ENDO ; ? ;

 DEL = ABS(X[1] - X[2]) ;
 IF INORM == 1 ;
   DIST = SUMC(SQRT(MD)) .* DEL ;
 ELSEIF INORM == 2 ;
   DIST = SUMC(MD) .* DEL ;
   DIST = SQRT(DIST) ;
 ELSEIF INORM == 3 ;
   DIST = MAXC(SQRT(MD)) ;
 ELSEIF INORM == 0 ;
   DIST = SUMC(MD) .* DEL ;
   DIST = SQRT(DIST) ;
   DIST = (SUMC(SQRT(MD)) .* DEL)|DIST ;
   DIST = DIST|MAXC(SQRT(MD)) ;
 ENDIF ;

 RETP(DIST) ;
ENDP ;
/* ============================ END PROC VDIST1S ======================== */

