/* =========================== START PROC VDIST2 ======================== */
PROC (1) = VDIST2(XGRID,V1,V2,VIND,ISCALE,INORM) ;
    /*  FOR EACH POINT IN XGRID~V1,  */
    /*  USES VIND, FROM VDIND, TO INDICATE  */
    /*  THE MEMBER OF XGRID~V2 THAT IS CLOSEST,  */
    /*  IN EUCLIDEAN R2 DISTANCE,   */
    /*  RETURNS THE "DISTANCE MEASURE":  */
    /*     L1 NORM,   WHEN INORM = 1 ;   */
    /*     L2 NORM,   WHEN INORM = 2 ;   */
    /*    SUP NORM,   WHEN INORM = 3 ;   */
    /*       ALL 3,   WHEN INROM = 0 ;   */
    /*  ISCALE = 0  FOR USING DISTANCE BASED ON RAW X AND Y VALUES  */
    /*         = 1  FOR USING DISTANCE BASED ON X AND Y MAPPED TO   */
    /*                      [0,1], ASSUMING X MIN = 0 AS IN K.D.E.  */
    /*         = 2  FOR USING DISTANCE BASED ON X AND Y MAPPED TO   */
    /*                    [0,1], NO RESTRICTIONS, AS IN REGRESSION  */

 LOCAL DENOM,X,MI,M1,M2,MDX,MDY,MD,DEL,DIST ;

 X = XGRID ;
 M1 = V1 ;
 M2 = V2 ;

 /*  RESCALE X'S TO [0,1]  */
 IF ISCALE /= 0 ;
   DENOM = MAXC(XGRID) - MINC(XGRID) ;
   IF DENOM /= 0 ;
     X = (XGRID - MINC(XGRID)) ./ DENOM ;
   ENDIF ;
 ENDIF ;

 /*  RESCALE V'S TO [0,1]  */
 IF ISCALE == 1 ;
   DENOM = MAXC(MAXC(V1~V2)) - 0 ;
   IF DENOM /= 0 ;
     M1 = V1 ./ DENOM ;
     M2 = V2 ./ DENOM ;
   ENDIF ;
 ELSEIF ISCALE == 2 ;
   MI = MINC(MINC(M1~M2)) ;
   DENOM = MAXC(MAXC(M1~M2)) - MI ;
   IF DENOM /= 0 ;
     M1 = (V1 - MI) ./ DENOM ;
     M2 = (V2 - MI) ./ DENOM ;
   ENDIF ;
 ENDIF ;

 MDX = X - X[VIND] ;
 MDX = MDX .* MDX ;
 MDY = M1 - M2[VIND] ;
 MDY = MDY .* MDY ;

 MD = MDX + MDY ;

 DEL = ABS(X[1] - X[2]) ;
 IF INORM == 1 ;
   DIST = SUMC(SQRT(MD)) .* DEL ;
 ELSEIF INORM == 2 ;
   DIST = SUMC(MD) .* DEL ;
   DIST = SQRT(DIST) ;
 ELSEIF INORM == 3 ;
   DIST = MAXC(SQRT(MD)) ;
 ELSEIF INORM == 0 ;
   DIST = SUMC(MD) .* DEL ;
   DIST = SQRT(DIST) ;
   DIST = (SUMC(SQRT(MD)) .* DEL)|DIST ;
   DIST = DIST|MAXC(SQRT(MD)) ;
 ENDIF ;

 RETP(DIST) ;
ENDP ;
/* ============================ END PROC VDIST2 ======================== */
