/* =========================== START PROC VDSYM1S ======================== */
PROC (1) = VDSYM1S(XGRID,V1,V2,ISCALE,INORM) ;
    /*  FINDS SYMMETRIZED VERSIONS OF VD'S,  */
    /*  BUT USES A SLOW LOOP TO HANDLE LARGER DATA VECTORS  */
    /*  RETURNS THE "DISTANCE MEASURE":  */
    /*     L1 NORM,   WHEN INORM = 1 ;   */
    /*     L2 NORM,   WHEN INORM = 2 ;   */
    /*    SUP NORM,   WHEN INORM = 3 ;   */
    /*       ALL 3,   WHEN INROM = 0 ;   */
    /*  ISCALE = 0  FOR USING DISTANCE BASED ON RAW X AND Y VALUES  */
    /*         = 1  FOR USING DISTANCE BASED ON X AND Y MAPPED TO   */
    /*                      [0,1], ASSUMING X MIN = 0 AS IN K.D.E.  */
    /*         = 2  FOR USING DISTANCE BASED ON X AND Y MAPPED TO   */
    /*                    [0,1], NO RESTRICTIONS, AS IN REGRESSION  */

 LOCAL DIST1,DIST2,DIST ;

 DIST1 = VDIST1S(XGRID,V1,V2,ISCALE,INORM) ;
 DIST2 = VDIST1S(XGRID,V2,V1,ISCALE,INORM) ;

  IF INORM == 1 ;
    DIST = DIST1 + DIST2 ;
  ELSEIF INORM == 2 ;
    DIST = SQRT(DIST1^2 + DIST2^2) ;
  ELSEIF INORM == 3 ;
    DIST = MAXC(DIST1|DIST2,1) ;
  ELSE ;
    DIST = DIST1[1] + DIST2[1] ;
    DIST = DIST|SQRT(DIST1[2]^2 + DIST2[2]^2) ;
    DIST = DIST|MAXC(DIST1[3]|DIST2[3]) ;
  ENDIF ;


 RETP(DIST) ;
ENDP ;
/* ============================ END PROC VDSYM1S ======================== */

