/* =========================== START PROC WV2R1 ======================== */
PROC WV2R1(COEFFS,ITYPE,IPAR,J0) ;
    /*  DOES "RECONSTRUCTION STEP" FOR A GENERAL WAVELET ESTIMATOR   */
    /*  THIS IS EXACTLY THE INVERSE OF THE VALUES FROM WV2D1   */
    /*  THIS ASSUMES A "CIRCULAR DESIGN",               */
    /*    I.E. DATA WILL BE TREATED AS PERIODIC.         */
    /*    FOR A SIMPLE BOUNDARY ADJUSTMENT, AUGMENT THE DATA      */
    /*    BY REFLECTING HALF AT EACH END, AND APPLYING THIS     */
    /*    TO THE RESULTING 2N VECTOR     */
    /*  INPUTS:       (NEED TO BE SAME AS IN WV2D1)     */
    /*     COEFFS = VECTOR LIKE OUTPUT FROM WV2D1   */
    /*              LENGTH = N = 2^M     (FOR SOME M)      */
    /*              THE LAST HALF ARE THE HIGHEST FREQUENCY "DIFS"   */
    /*                I.E. "HI PASS FILTERED VALUES"      */
    /*                FORMERLY CALLED "DISCREPANCIES"   */
    /*              THE SECOND QUARTER ARE NEXT HIGHEST, ETC.     */
    /*              THE FIRST 2^J0 ARE THE NEW "AVGS",      */
    /*                I.E. "LOW PASS FILTERED VALUES"     */
    /*                FORMERLY CALLED "PREDICTED VALUES"   */
    /*     ITYPE = 1 - HAAR BASIS    (IPAR IGNORED)      */
    /*           = 2 - DAUBECHIES    (IPAR = 4, 6)     */
    /*           = 3 - SYMMLETS      (IPAR = 6, 8)       */
    /*           = 4 - COIFLETS      (IPAR = 2, 3)       */
    /*     IPAR = PARAMETER WITHIN FAMILIES       */
    /*     J0 = ROW NUMBER OF LOWEST FREQUENCY "DIFS"    */
    /*        = -1 GIVES SMALLEST ALLOWABLE FOR CHOSEN BASIS  */
    /*  OUTPUT IS THE RECONSTRUCTED DATA    */
    /*  GENERAL ALGORITHM STRUCTURE IS SIMPLY MATRIX TRANSPOSE    */
    /*           FROM WRITING DECOMP AS MATRIX PRODUCT   */
    /*  COEFFICIENTS FROM DJ, OUT OF DAUBECHIES BOOK "10 Lectures"  */
    /*  BUT MODIFIED TO INCLUDE VARIANCE PRESERVING PROPERTY    */

  LOCAL N,JE,CLO,NFIL,J0U,CHI,OLDAVG,J,NJ,AVG,DIF,YFAVG,YFDIF ;

  N = ROWS(COEFFS) ;
  JE = LOG(N) ./ LOG(2) ;      /*  LOG BASE 2  */
  JE = ROUND(JE) ;

  IF ABS(2^JE - N) > 10^(-10) ;
    "******************************************************" ;
    "***   CAREFUL n IS NOT A POWER OF 2, RETURNING 0   ***" ;
    "******************************************************" ;
   RETP(0) ;
  ENDIF ;


  IF ITYPE == 1 ;      /*  HAAR BASIS  */
    CLO = ONES(2,1) ./ SQRT(2) ;
  ELSEIF ITYPE == 2 ;     /*  DAUBECHIES BASES  */
    IF IPAR == 4 ;
      CLO = .482962913145|.836516303738|.224143868042|-.129409522551 ;
    ELSEIF IPAR == 6 ;
      CLO = .332670552950|.806891509311|.459877502118|-.135011020010 ;
      CLO = CLO|-.085441273882|.035226291882 ;
    ENDIF ;
  ELSEIF ITYPE == 3 ;     /*  SYMMLET BASES  */
    IF IPAR == 6 ;
      CLO = .021784700327|.004936612372|-.166863215412 ;
      CLO = CLO|-.068323121587|.694457972958|1.113892783926 ;
      CLO = CLO|.477904371333|-.102724969862|-.029783751299 ;
      CLO = CLO|.063250562660|.002499922093|-.011031867509 ;
    ELSEIF IPAR == 8 ;
      CLO = .002672793393|-.000428394300|-.021145686528 ;
      CLO = CLO|.005386388754|.069490465911|-.038493521263 ;
      CLO = CLO|-.073462508761|.515398670374|1.099106630537 ;
      CLO = CLO|.680745347190|-.086653615406|-.202648655286 ;
      CLO = CLO|.010758611751|.044823623042|-.000766690896|-.004783458512 ;
    ENDIF ;
          /*  NEED TO READJUST DUE TO STRANGE NORMALIZATION   */
    CLO = CLO / SQRT(2) ;
  ELSEIF ITYPE == 4 ;     /*  COIFLET BASES  */
    IF IPAR == 2 ;
      CLO = .011587596739|-.029320137980|-.047639590310 ;
      CLO = CLO|.273021046535|.574682393857|.294867193696 ;
      CLO = CLO|-.054085607092|-.042026480461|.016744410163 ;
      CLO = CLO|.003967883613|-.001289203356|-.000509505399 ;
    ELSEIF IPAR == 3 ;
      CLO = -.002682418671|.005503126709|.016583560479 ;
      CLO = CLO|-.046507764479|-.043220763560|.286503335274 ;
      CLO = CLO|.561285256870|.302983571773|-.050770140755 ;
      CLO = CLO|-.058196250762|.024434094321|.011229240962 ;
      CLO = CLO|-.006369601011|-.001820458916|.000790205101 ;
      CLO = CLO|.000329665174|-.000050192775|-.000024465734 ;
    ENDIF ;
          /*  NEED TO READJUST DUE TO STRANGE NORMALIZATION   */
    CLO = CLO * SQRT(2) ;
  ENDIF ;

  NFIL = ROWS(CLO) ;           /*   FILTER LENGTH  */

  IF J0 == -1 ;
    J0U = CEIL(LOG(NFIL)/LOG(2)) - 1 ;
  ELSEIF 2^(J0+1) < NFIL ;
    "**************************************************************" ;
    "***   CAREFUL, J0 TOO SMALL FOR THIS FILTER, RETURNING 0   ***" ;
    "**************************************************************" ;
   RETP(0) ;
  ELSE ;
    J0U = J0 ;
  ENDIF ;


  CHI = REV(CLO) ;
  CHI = SEQM(-1,-1,NFIL) .* CHI ;
          /*  THESE WERE USED IN DECOMP   */
          /*  BEFORE ROW REVERSAL   */

          /*  PUT IN FORM FOR INVERSION  */
  CLO = RESHAPE(CLO,NFIL/2,2) ;
  CHI = RESHAPE(CHI,NFIL/2,2) ;

  OLDAVG = COEFFS[1:2^J0U] ;
  J = J0U ;
  DO WHILE J <= JE - 1 ;
                    /*  LOOP THROUGH LEVELS, STARTING AT LOW FREQ  */

    NJ = 2^J ;       /*  NUMBER OF EACH TYPE WILL INVERT  */
    AVG = OLDAVG ;
    DIF = COEFFS[NJ+1:2*NJ] ;

           /*  PAD OUT TO GET PERIODICITY   */
    IF NFIL > 2 ;       /*  NEED TO PAD WITH NON HAAR BASIS  */
      AVG = AVG[NJ-(NFIL/2)+2:NJ]|AVG ;
                        /*  DJ'S PRE PADDING   */
      DIF = DIF|DIF[1:(NFIL/2)-1] ;
                        /*  DJ'S POST PADDING   */
    ENDIF ;

           /*  DO FILTERING   */
    YFAVG = CONV(AVG,CLO[.,1],NFIL/2,NJ+(NFIL/2)-1) ;
    YFAVG = YFAVG~CONV(AVG,CLO[.,2],NFIL/2,NJ+(NFIL/2)-1) ;
    YFDIF = CONV(DIF,CHI[.,1],NFIL/2,NJ+(NFIL/2)-1) ;
    YFDIF = YFDIF~CONV(DIF,CHI[.,2],NFIL/2,NJ+(NFIL/2)-1) ;

           /*  RECOMBINE TO GET Y'S  */
    YFAVG = RESHAPE(YFAVG,2*NJ,1) ;
    YFDIF = RESHAPE(YFDIF,2*NJ,1) ;

    OLDAVG = YFAVG + YFDIF ;

    J = J + 1 ;
  ENDO ;


  RETP(OLDAVG) ;
ENDP ;
/* ============================ END PROC WV2R1 ========================= */
