"GAUSS PROGRAM WVBA1C.PRG" ;
/*  FOR BAYESIAN APPROACH TO WAVELETS  */
/*  THIS USES MONTE CARLO MARKOV CHAIN, WITH SIGMA INTEGREATED OUT  */
/*  LOOKS AT CHANGING C/(C+1) TO 1 IN THE MIXTURE ESTIMATES  */

LIBRARY PGRAPH ;
GRAPHSET ;

AUTOP = 2 ;       /*  0 TO VIEW ON SCREEN   */
                  /*  1 TO WRITE TO HPGL FILE FOR LAS PLOT  */
                  /*  2 TO WRITE AS POSTSCRIPT FILES  */


N = 256 ;          /*   SAMPLE SIZE  = NUMBER OF GRID POINTS   */
                    /*   MUST BE A POWER OF 2  */

ITARGET = 0 ;       /*   0 - LOOP THROUGH ALL    */
                    /*   1 - STEP       */
                    /*   2 - WAVE       */
                    /*   3 - BLIP       */
                    /*   4 - BLOCKS     */
                    /*   5 - BUMPS      */
                    /*   6 - HEAVSI     */
                    /*   7 - DOPPL      */
                    /*   8 - ANGLES     */
                    /*   9 - PARABS     */
                    /*   10 - SHSIN     */

ISIGMA = 2 ;        /*   0 - LOOP THROUGH ALL    */
                    /*   1 - "LOW NOISE"       */
                    /*   2 - "HIGH NOISE"       */

VIBASIS = 1|2|5|8 ;       /*  LOOP THROUGH ENTRIES OF THIS VECTOR  */
/* BASES:               1 - HAAR    */
                    /*  2 - DAUBECHIES 4    */
                    /*  3 - DAUBECHIES 6    */
                    /*  4 - SYMMLET 6    */
                    /*  5 - SYMMLET 8    */
                    /*  6 - COIFLET 2    */
                    /*  7 - COIFLET 3    */
                    /*  8 - FOURIER    */



NSTR = FTOS(N,"%*.*lf",1,0) ;
DELX = 1 / N ;
XGRID = SEQA(DELX/2,DELX,N) ;


                  /*  SET BAYES MARKOV CHAIN STUFF   */
NIT = 1000 ;                   /*  NUMBER OF ITERATIONS    */
ITBI = 500 ;                   /*  ITERATION NUMBER WHERE HAVE BURNED IN  */
C = 100 ;
SVGAMM = ZEROS(N,1) ;          /*  STARTING GAMMA VECTOR   */
SMCSEED = 797288723 ;          /*  STARTING SEED FOR MARKOV CHAIN  */


                  /*  SET GRAPHICS STUFF  */
_PLCTRL = 0|-1|0 ;
_PSTYPE = 4 ;
_PSYMSIZ = .25 ;
_PDATE = "From WVBA1C.PRG     " ;
_PDATE = "" ;
  LEFT = 0 ;
  RIGHT = 1 ;
  XSTEP = .2 ;
  XMSD = 2 ;
XTICS(LEFT,RIGHT,XSTEP,XMSD) ;
  BOTTOM = 0 ;
  TOP = 1 ;
  YSTEP = .2 ;
  YMSD = 2 ;
YTICS(BOTTOM,TOP,YSTEP,YMSD) ;



                  /*  SET UP LOOPING STUFF  */
IF ITARGET == 0 ;
  ITS = 1 ;
  ITE = 10 ;
ELSE ;
  ITS = ITARGET ;
  ITE = ITARGET ;
ENDIF ;

IF ISIGMA == 0 ;
  ISS = 1 ;
  ISE = 2 ;
ELSE ;
  ISS = ISIGMA ;
  ISE = ISIGMA ;
ENDIF ;

NB = ROWS(VIBASIS) ;



IT = ITS ;      /*  LOOP THROUGH TARGET FUNCTIONS  */
DO WHILE IT <= ITE ;

  IF IT == 1 ;
    TARSTR = "Step" ;
    M = 0.2 ;      /*  BASE HEIGHT  */
    M = M + (1/3 .< XGRID) .* (XGRID .< .75) * .6 ;
                   /*  RAISE BY .4 ON THIS INTERVAL  */
    _PLEGCTL = 1|4|.37|0 ;
    VK = .3|.31|.32|.33|.34|.35 ;
    VK = VK|.72|.73|.74|.75|.76|.77 ;
  ELSEIF IT == 2 ;
    TARSTR = "Wave" ;
    M = .2 * COS(XGRID * 2 * PI * 2) + .5 ;
    M = M + .1 * COS(XGRID * 2 * PI * 12) ;
    _PLEGCTL = 1|4|0.61|.8 ;
  ELSEIF IT == 3 ;
    TARSTR = "Blip" ;
    M = .6 * XGRID + .2 ;
    M = M + .3 * EXP(-100 * (XGRID - .5) .* (XGRID - .5)) ;
      RM = ROWS(M) ;
    M = M[(RM/5)+1:RM]|M[1:RM/5] ;
    _PLEGCTL = 1|4|.6|0 ;
  ELSEIF IT == 4 ;
    TARSTR = "Blocks" ;
      T = .1|.13|.15|.23|.25|.40|.44|.65|.76|.78|.81 ;
      H = 4|-5|3|-4|5|-4.2|2.1|4.3|-3.1|2.1|-4.2 ;
    M = XGRID' - T ;
      FLAG = M .> 0 ;
      FLAG0 = M .== 0 ;
    M = FLAG - (1 - FLAG - FLAG0) ;       /*  GIVES SGN(M)  */
    M = (1 + M) / 2 ;
    M = H .* M ;
    M = SUMC(M) ;                     /*  THIS IS NOW DJ'S BLOCKS   */
    M = (.6 / 9.2) * (M + 2) + .2 ;      /*  RESCALED TO [.2,.8]  */
    _PLEGCTL = 1|4|.6|0 ;
  ELSEIF IT == 5 ;
    TARSTR = "Bumps" ;
      T = .1|.13|.15|.23|.25|.40|.44|.65|.76|.78|.81 ;
      H = 4|5|3|4|5|4.2|2.1|4.3|3.1|5.1|4.2 ;
      W = .005|.005|.006|.01|.01|.03|.01|.01|.005|.008|.005 ;
    M = (XGRID' - T) ./ W ;
    M = 1 ./ (1 + ABS(M))^4 ;
    M = H .* M ;
    M = SUMC(M) ;                     /*  THIS IS NOW DJ'S BUMPS   */
    M = (.6/5.3437952) * M + .2 ;      /*  RESCALED TO [.2,.8]  */
    _PLEGCTL = 1|4|.6|0 ;
  ELSEIF IT == 6 ;
    TARSTR = "HeavSi" ;
    M = 4 * SIN(4 * PI * XGRID) ;
      FLAG = XGRID .> .3 ;
      FLAG0 = XGRID .== .3 ;
    M = M - (FLAG - (1 - FLAG - FLAG0)) ;
      FLAG = XGRID .> .72 ;
      FLAG0 = XGRID .== .72 ;
    M = M + (FLAG - (1 - FLAG - FLAG0)) ;     /*  DJ'S HEAVY SINE  */
    M = (.6 / 9) * (M + 5) + .2 ;      /*  RESCALED TO [.2,.8]  */
    _PLEGCTL = 1|4|.6|0 ;
  ELSEIF IT == 7 ;
    TARSTR = "Doppl" ;
    M = SQRT(XGRID .* (1 - XGRID)) ;
    M = M .* SIN(2 * PI * 1.05 ./ (XGRID + .05)) ;   /*  DJ'S DOPPLER   */
    M = (.6 / 1) * (M + .5) + .2 ;      /*  RESCALED TO [.2,.8]  */
    _PLEGCTL = 1|4|.6|0 ;
  ELSEIF IT == 8 ;
    TARSTR = "Angles" ;
    M = (XGRID .<= .15) .* (2 * XGRID + .5) ;
    M = M + (.15 .< XGRID) .* (XGRID .<= .2) .* (-12 * (XGRID -.15) + .8)  ;
    M = M + (.2 .< XGRID) .* (XGRID .<= .5) .* (.2)  ;
    M = M + (.5 .< XGRID) .* (XGRID .<= .6) .* (6 * (XGRID -.5) + .2)  ;
    M = M + (.6 .< XGRID) .* (XGRID .<= .65) .* (-10 * (XGRID -.6) + .8)  ;
    M = M + (.65 .< XGRID) .* (XGRID .<= .85) .* (-1/2 * (XGRID -.65) + .3) ;
    M = M + (.85 .< XGRID) .* (2 * (XGRID -.85) + .2)  ;
    _PLEGCTL = 1|4|.6|0 ;
  ELSEIF IT == 9 ;
    TARSTR = "Parabs" ;
    M = .8 .* ONES(N,1) ;
    M = M + (.1 .< XGRID) .* (-30 .* (XGRID - .1)^2) ;
    M = M + (.2 .< XGRID) .* (60 .* (XGRID - .2)^2) ;
    M = M + (.3 .< XGRID) .* (-30 .* (XGRID - .3)^2) ;
    M = M + (.35 .< XGRID) .* (500 .* (XGRID - .35)^2) ;
    M = M + (.37 .< XGRID) .* (-1000 .* (XGRID - .37)^2) ;
    M = M + (.41 .< XGRID) .* (1000 .* (XGRID - .41)^2) ;
    M = M + (.43 .< XGRID) .* (-500 .* (XGRID - .43)^2) ;
    M = M + (.5 .< XGRID) .* (7.5 .* (XGRID - .5)^2) ;
    M = M + (.7 .< XGRID) .* (-15 .* (XGRID - .7)^2) ;
    M = M + (.9 .< XGRID) .* (7.5 .* (XGRID - .9)^2) ;
    _PLEGCTL = 1|4|.6|0 ;
  ELSEIF IT == 10 ;
    TARSTR = "TShSin" ;
    TXGRID = (1 - COS(PI .* XGRID)) / 2 ;
    TXGRID = (1 - COS(PI .* TXGRID)) / 2 ;
    TXGRID = (1 - COS(PI .* TXGRID)) / 2 ;
    TXGRID = (1 - COS(PI .* TXGRID)) / 4 + XGRID / 2 ;
    M = .3 * SIN(6 .* PI .* TXGRID) + .5 ;
    _PLEGCTL = 1|4|.6|0 ;
  ENDIF ;



  IS = ISS ;      /*  LOOP THROUGH SIGMAS  */
  DO WHILE IS <= ISE ;

    IF IS == 1 ;
      SIGSTR = "Low Noise" ;
      SIG = .02 ;
    ELSEIF IS == 2 ;
      SIGSTR = "High Noise" ;
      SIG = .1 ;
    ENDIF ;


      SEED = 932485732 ;
    DATA = M + SIG * RNDNS(N,1,SEED) ;


    BEGWIND ;
    WINDOW(2,2,0) ;


    IB = 1 ;      /*  LOOP THROUGH BASES  */
    DO WHILE IB <= NB ;
      IBAS = VIBASIS[IB] ;

      IF IBAS <= 7 ;
      J0 = -1 ;       /*  DECOMPOSE AS MUCH AS POSSIBLE  */
        IF IBAS == 1 ;
          ITYPE = 1 ;
          IPAR = 0 ;
          BASTR = "Haar" ;
        ELSEIF IBAS == 2 ;
          ITYPE = 2 ;
          IPAR = 4 ;
          BASTR = "Daub4" ;
        ELSEIF IBAS == 3 ;
          ITYPE = 2 ;
          IPAR = 6 ;
          BASTR = "Daub6" ;
        ELSEIF IBAS == 4 ;
          ITYPE = 3 ;
          IPAR = 6 ;
          BASTR = "Symm6" ;
        ELSEIF IBAS == 5 ;
          ITYPE = 3 ;
          IPAR = 8 ;
          BASTR = "Symm8" ;
        ELSEIF IBAS == 6 ;
          ITYPE = 4 ;
          IPAR = 2 ;
          BASTR = "Coif2" ;
        ELSEIF IBAS == 7 ;
          ITYPE = 4 ;
          IPAR = 3 ;
          BASTR = "Coif3" ;
        ENDIF ;

                /*  GET WAVELET COEFFS OF DATA  */
        Y = WV2D1(DATA,ITYPE,IPAR,J0) ;

      ELSEIF IBAS == 8 ;
        BASTR = "Fourier" ;

        Y = WVFFTD(DATA) ;

      ENDIF ;



      "DOING MCMC FOR "$+BASTR$+" BASIS, "$+TARSTR$+" REG, "$+SIGSTR ;

      MCSEED = SMCSEED ;
      NO2 = N / 2 ;
      Y2 = Y .* Y ;
      YPY = SUMC(Y2) ;
      ISCP1 = 1 / SQRT(C + 1) ;
      CP1 = C + 1 ;
      CO1PC = C / CP1 ;
      LCP1 = LN(CP1) ;
      VGAMM = SVGAMM ;
      Q = SUMC(VGAMM) ;
      YGAMM = VGAMM .* Y ;       /*  Y'S WHERE GAMM = 1   */


      "FOR OLD MIXTURE ESTIMATE " ;
      SO = YPY - CO1PC * (YGAMM' * YGAMM) ;
      SUMGAMMO = ZEROS(N,1) ;
      IIT = 1 ;
      DO WHILE IIT <= NIT ;
        "." ;;
        VUNIF = RNDUS(N,1,MCSEED) ;

        /*  RECOMPUTE STUFF FOR STABILITY  */
        YGAMM = VGAMM .* Y ;       /*  Y'S WHERE GAMM = 1   */
        SO = YPY - CO1PC * (YGAMM' * YGAMM) ;

        I = 1 ;
        DO WHILE I <= N ;

          IF VGAMM[I] == 0 ;
            S0 = SO ;
            S1 = SO - CO1PC * Y2[I] ;
            Q0 = Q ;
            Q1 = Q + 1;
          ELSE ;
            S0 = SO + CO1PC * Y2[I] ;
            S1 = SO ;
            Q0 = Q - 1 ;
            Q1 = Q ;
          ENDIF ;


          ARG = NO2 * (LN(S0) - LN(S1)) ;
          IF ARG <= 500 ;   /*  WON'T GIVE EXP = INF  */

            R = ISCP1 * EXP(NO2 * (LN(S0) - LN(S1))) ;
                           /*  CAREFUL ABOUT LOSS OF ACCURACY HERE  */
                           /*  TO CHECK, USE THE FOLLOWING LINES,    */
                           /*  WHICH MEAN A VERY SLOW EXECUTION  */
/*
"UNSTABLE WHEN THIS IS CLOSE TO 1:    " (1 / (1 + CO1PC * Y2[I]) / S) ;
WAIT ;
*/

            PROB = R / (1 + R) ;
          ELSE ;     /*  TOO BIG FOR EXP, THEREFORE MAKE PROB = 1   */
            PROB = 1 ;
          ENDIF ;


          TOSS = (VUNIF[I] < PROB) ;     /*  1 WITH THAT PROB  */

          IF TOSS == 0 ;
            VGAMM[I] = 0 ;
            SO = S0 ;
            Q = Q0 ;
          ELSE ;
            VGAMM[I] = 1 ;
            SO = S1 ;
            Q = Q1 ;
          ENDIF ;

          I = I + 1 ;
        ENDO ;

        IF IIT >= ITBI ;    /*  HAVE "BURNED IN" MARKOV CHAIN  */
          SUMGAMMO = SUMGAMMO + VGAMM ;
        ENDIF ;


        IIT = IIT + 1 ;
      ENDO ; ? ; ? ;




      "FOR NEW MIXTURE ESTIMATE " ;
      VGAMM = SVGAMM ;
      Q = SUMC(VGAMM) ;
      YGAMM = VGAMM .* Y ;       /*  Y'S WHERE GAMM = 1   */
      SN = YPY - 1 * (YGAMM' * YGAMM) ;
      SUMGAMMN = ZEROS(N,1) ;
      IIT = 1 ;
      DO WHILE IIT <= NIT ;
        "." ;;
        VUNIF = RNDUS(N,1,MCSEED) ;

        /*  RECOMPUTE STUFF FOR STABILITY  */
        YGAMM = VGAMM .* Y ;       /*  Y'S WHERE GAMM = 1   */
        SN = YPY - 1 * (YGAMM' * YGAMM) ;

        I = 1 ;
        DO WHILE I <= N ;

          IF VGAMM[I] == 0 ;
            S0 = SN ;
            S1 = SN - 1 * Y2[I] ;
            Q0 = Q ;
            Q1 = Q + 1;
          ELSE ;
            S0 = SN + 1 * Y2[I] ;
            S1 = SN ;
            Q0 = Q - 1 ;
            Q1 = Q ;
          ENDIF ;

          ARG = NO2 * (LN(S0) - LN(S1)) ;
          IF ARG <= 500 ;   /*  WON'T GIVE EXP = INF  */

            R = ISCP1 * EXP(NO2 * (LN(S0) - LN(S1))) ;
                           /*  CAREFUL ABOUT LOSS OF ACCURACY HERE  */
                           /*  TO CHECK, USE THE FOLLOWING LINES,    */
                           /*  WHICH MEAN A VERY SLOW EXECUTION  */
/*
"UNSTABLE WHEN THIS IS CLOSE TO 1:    " (1 / (1 + CO1PC * Y2[I]) / S) ;
WAIT ;
*/

            PROB = R / (1 + R) ;
          ELSE ;     /*  TOO BIG FOR EXP, THEREFORE MAKE PROB = 1    */
            PROB = 1 ;
          ENDIF ;


          TOSS = (VUNIF[I] < PROB) ;     /*  1 WITH THAT PROB  */

          IF TOSS == 0 ;
            VGAMM[I] = 0 ;
            SN = S0 ;
            Q = Q0 ;
          ELSE ;
            VGAMM[I] = 1 ;
            SN = S1 ;
            Q = Q1 ;
          ENDIF ;

          I = I + 1 ;
        ENDO ;

        IF IIT >= ITBI ;    /*  HAVE "BURNED IN" MARKOV CHAIN  */
          SUMGAMMN = SUMGAMMN + VGAMM ;
        ENDIF ;


        IIT = IIT + 1 ;
      ENDO ; ? ; ? ;


      AVGAMMO = SUMGAMMO / (NIT - ITBI + 1) ;
      AVGAMMN = SUMGAMMN / (NIT - ITBI + 1) ;

      BHATAVGO = AVGAMMO .* Y ;     /*  "MEAN TYPE" BETA HATS   */
      BHATAVGN = AVGAMMN .* Y ;     /*  "MEAN TYPE" BETA HATS   */


             /*  INVERT WAVELET TRANSFORMS TO GET ESTS    */
      IF IBAS <= 7 ;
        MHATAVGO = WV2R1(BHATAVGO,ITYPE,IPAR,J0) ;
        MHATAVGN = WV2R1(BHATAVGN,ITYPE,IPAR,J0) ;
      ELSEIF IBAS == 8 ;
        MHATAVGO = WVFFTR(BHATAVGO) ;
        MHATAVGN = WVFFTR(BHATAVGN) ;
      ENDIF ;



      SETWIND(IB) ;
        _PDATE = "from GAUSS Program WVBA1C.PRG      " ;
        _PLCTRL = 0 ;
        _PLTYPE = 6|1|4 ;
        _PLEGSTR = "Target\000Old Avg\000New Avg" ;
          TITSTR = TARSTR$+" Target, MCMC Wavelet Ests (int'd sig), " ;
          TITSTR = TITSTR$+BASTR$+" Basis\L" ;
          TITSTR = TITSTR$+SIGSTR ;
          TITSTR = TITSTR$+" (sig = "$+FTOS(SIG,"%*.*lf",3,2) ;
          TITSTR = TITSTR$+"),  n = " ;
          TITSTR = TITSTR$+FTOS(N,"%*.*lf",1,0) ;
          TITSTR = TITSTR$+",  C = "$+FTOS(C,"%*.*lf",6,2) ;
        TITLE(TITSTR) ;
      XY(XGRID,M~MHATAVGO~MHATAVGN) ; ? ;


      IB = IB + 1 ;
    ENDO ;



    IF AUTOP == 1 ;
        PRSTR = "-C=3 -CF=\\GAUSS\\STEVE\\PS\\BA1C" ;
        PRSTR = PRSTR$+FTOS(IT,"%*.*lf",1,0) ;
        PRSTR = PRSTR$+FTOS(IS,"%*.*lf",1,0) ;
        PRSTR = PRSTR$+".PLT" ;
      GRAPHPRT(PRSTR) ;
    ELSEIF AUTOP == 2 ;
        PRSTR = "-C=1 -CF=\\GAUSS\\STEVE\\PS\\BA1C" ;
        PRSTR = PRSTR$+FTOS(IT,"%*.*lf",1,0) ;
        PRSTR = PRSTR$+FTOS(IS,"%*.*lf",1,0) ;
        PRSTR = PRSTR$+".PS" ;
      GRAPHPRT(PRSTR) ;
    ENDIF ;

    ENDWIND ;


    IS = IS + 1 ;
  ENDO ;

  IT = IT + 1 ;
ENDO ;

END ;


