/* =========================== START PROC WVBD ======================== */
PROC WVBD(Y) ;
    /*  DOES "DECOMPOSITION STEP" IN BOCK WAVELET ESTIMATOR   */
    /*  Y IS VECTOR OF Y VALUES, WHERE CORRESPONDING X'S   */
    /*  ARE ASSUMED TO BE:   0,1,2,...,(2^M - 1)     (FOR SOME M)   */
    /*  I.E. NUMBERS ON ENTRIES IN Y NEEDS TO BE A POWER OF 2  */
    /*                NOTE THIS ALGORITHM ASSUMES A "CIRCULAR DESIGN"  */
    /*  OUTPUT IS A 2 COLUMN MATRIX,    */
    /*      THE FIRST COLUMN IS THE NEW "PREDICTED VALUES"   */
    /*      THE SECOND COLUMN IS THE "DISCREPANCIES"   */
    /*  GENERAL ALGORITHM STRUCTURE IS AN ADAPTATION OF THE IDEAS   */
    /*  IN BOCK (1992) STAT. COMP. AND STAT. GRA. NEWS., 3, 27-34.  */

  LOCAL N,M,C,MU,OMMU,NEWY,R,IS,IE,J,ISO,IEO,NJ,TEMPY ;

  N = ROWS(Y) ;
  M = LOG(N) ./ LOG(2) ;      /*  LOG BASE 2  */
  M = ROUND(M) ;

  IF ABS(2^M - N) > 10^(-10) ;
    "******************************************************" ;
    "***   CAREFUL n IS NOT A POWER OF 2, RETURNING 0   ***" ;
    "******************************************************" ;
   RETP(0) ;
  ENDIF ;

  C = (1+SQRT(3))|(3+SQRT(3))|(3-SQRT(3))|(1-SQRT(3)) ;
  C = C / 4 ;
  MU = (3 - SQRT(3)) / 2 ;
  OMMU = 1 - MU ;

  NEWY = ZEROS(N-2,1) ;
  R = ZEROS(N-2,1) ;

             /*  FIRST ITERATION USES RAW DATA  */
  IS = 1 ;
  IE = N/2 ;
  TEMPY = RESHAPE(Y,IE,2) ;
  TEMPY = TEMPY~(TEMPY[2:IE,.]|TEMPY[1,.]) ;
  NEWY[IS:IE] = (TEMPY * C) / 2 ;
  R[IS:IE] = OMMU * TEMPY[.,1] + MU * TEMPY[.,2] - NEWY[IS:IE] ;

  J = 2 ;
  DO WHILE J <= M-1 ;     /*  LOOP THROUGH LEVELS  */

    ISO = IS ;
    IEO = IE ;

    NJ = 2^(M-J) ;

    IS = IEO + 1 ;
    IF J < M ;
      IE = IS + NJ - 1 ;
    ELSE ;
      IE = IS ;
    ENDIF ;

    TEMPY = RESHAPE(NEWY[ISO:IEO],NJ,2) ;
    TEMPY = TEMPY~(TEMPY[2:NJ,.]|TEMPY[1,.]) ;
    NEWY[IS:IE] = (TEMPY * C) / 2 ;
    R[IS:IE] = OMMU * TEMPY[.,1] + MU * TEMPY[.,2] - NEWY[IS:IE] ;

    J = J + 1 ;
  ENDO ;


  RETP(NEWY~R) ;
ENDP ;
/* ============================ END PROC WVBD ========================= */
