/* =========================== START PROC WVD4D ======================== */
PROC WVD4D(Y,AL,AR) ;
    /*  DOES "DECOMPOSITION STEP" IN DAUBECHIES' D4 WAVELET ESTIMATOR   */
    /*  Y IS VECTOR OF Y VALUES, WHERE CORRESPONDING X'S   */
    /*  ARE ASSUMED TO BE:   0,1,2,...,(2^M - 1)     (FOR SOME M)   */
    /*  I.E. NUMBERS ON ENTRIES IN Y NEEDS TO BE A POWER OF 2  */
    /*  OUTPUT IS A 2 COLUMN MATRIX,    */
    /*      THE FIRST COLUMN IS THE NEW "PREDICTED VALUES"   */
    /*      THE SECOND COLUMN IS THE "DISCREPANCIES"   */
    /*  GENERAL ALGORITHM STRUCTURE IS AN ADAPTATION OF THE IDEAS   */
    /*  IN BOCK (1992) STAT. COMP. AND STAT. GRA. NEWS., 3, 27-34.  */
    /*  BUT MODIFIED TO INCLUDE:             */
    /*           1.   A PROPER BOUNDARY ADJUSTMENT    */
    /*           2.   VARIANCE PRESERVING PROPERTY    */
    /*  THE PARAMETERS AL AND AR CONTROL THE TYPE OF BOUNDARY ADJUSTMENT  */
    /*      RECOMMENDED VALUES ARE:   */
    /*           AL = 4 - 2 * SQRT(3),   AR = -4 + 2 * SQRT(3)   */

  LOCAL N,M,CHIRAW,CLORAW,CHI,CLO,CHIL,CLOL,CHIR,CLOR,
      OLDY,NEWY,R,IS,IE,J,NJ,TEMPY ;

  N = ROWS(Y) ;
  M = LOG(N) ./ LOG(2) ;      /*  LOG BASE 2  */
  M = ROUND(M) ;

  IF ABS(2^M - N) > 10^(-10) ;
    "******************************************************" ;
    "***   CAREFUL n IS NOT A POWER OF 2, RETURNING 0   ***" ;
    "******************************************************" ;
   RETP(0) ;
  ENDIF ;

  CHIRAW = (-5+3*SQRT(3))|(9-5*SQRT(3))|(-3+SQRT(3))|(-1+SQRT(3)) ;
  CLORAW = (1+SQRT(3))|(3+SQRT(3))|(3-SQRT(3))|(1-SQRT(3)) ;

  CHI = VLTO1(CHIRAW) ;
  CLO = VLTO1(CLORAW) ;

  CHIL = VLTO1(AL|CHIRAW[3 4]) ;
  CLOL = VLTO1(  ((16-8*SQRT(3)) / AL)|CLORAW[3 4]  ) ;

  CHIR = VLTO1(CHIRAW[1 2]|AR) ;
  CLOR = VLTO1(  CLORAW[1 2]|((-16+8*SQRT(3)) / AR)  ) ;

  OLDY = Y ;
  NEWY = ZEROS(N-2,1) ;
  R = ZEROS(N-2,1) ;

  IE = 0 ;
  J = 1 ;
  DO WHILE J <= M-1 ;     /*  LOOP THROUGH LEVELS  */

    NJ = 2^(M-J) ;     /*  NUMBER OF NEW COEFFS IN THIS STEP  */
    IS = IE + 1 ;      /*  STARTING INDEX OF NEW COEFFS IN THIS STEP  */
    IF J < M ;         /*  ENDING INDEX OF NEW COEFFS IN THIS STEP  */
      IE = IS + NJ - 1 ;
    ELSE ;
      IE = IS ;
    ENDIF ;

    IF J <= M - 2 ;
      TEMPY = RESHAPE(OLDY[2:2*NJ-1],NJ-1,2) ;
      TEMPY = TEMPY[1:NJ-2,.]~TEMPY[2:NJ-1,.] ;
      R[IS+1:IE-1] = TEMPY * CHI ;
      NEWY[IS+1:IE-1] = TEMPY * CLO ;
    ENDIF ;

    R[IS] = (OLDY[1 2 3]' * CHIL) ;
    R[IE] = (OLDY[2*NJ-2 2*NJ-1 2*NJ]' * CHIR) ;
    NEWY[is] = (OLDY[1 2 3]' * CLOL) ;
    NEWY[IE] = (OLDY[2*NJ-2 2*NJ-1 2*NJ]' * CLOR) ;

    OLDY = NEWY[IS:IE] ;

    J = J + 1 ;
  ENDO ;


  RETP(NEWY~R) ;
ENDP ;
/* ============================ END PROC WVD4D ========================= */
