/* =========================== START PROC WVD4R ======================== */
PROC WVD4R(YR,AL,AR) ;
    /*  DOES "RECONSTRUCTION STEP" IN DAUBECHIES' D4 WAVELET ESTIMATOR   */
    /*  FOR REGRESSION, WHERE X'S ARE ASSUMED TO BE:    */
    /*              0,1,2,...,(2^M - 1)     (FOR SOME M)   */
    /*  I.E. NUMBERS ON ENTRIES IN Y NEEDS TO BE A POWER OF 2  */
    /*  YR IS A 2 COLUMN MATRIX,                        */
    /*      THE FIRST COLUMN IS THE "PREDICTED VALUES"     */
    /*                                FROM "LO PASS FILTER"   */
    /*      THE SECOND COLUMN IS THE "MODIFIED DISCREPANCIES"   */
    /*                                FROM "HI PASS FILTER"   */
    /*              (USUALLY "SHRUNK" OR "THRESHOLDED")    */
    /*  AS OUTPUT BY WVD4R.G                                  */
    /*  GENERAL ALGORITHM STRUCTURE IS AN ADAPTATION OF THE IDEAS   */
    /*  IN BOCK (1992) STAT. COMP. AND STAT. GRA. NEWS., 3, 27-34.  */
    /*  BUT MODIFIED TO INCLUDE:             */
    /*           1.   A PROPER BOUNDARY ADJUSTMENT    */
    /*           2.   VARIANCE PRESERVING PROPERTY    */
    /*  THIS DOES NOT USE THE LAST TWO WAVELET COEFFICIENTS,   */
    /*      BECAUSE THEY ARE HARD TO INVERT, AND DON'T SEEM WORTH IT  */
    /*  THE PARAMETERS AL AND AR CONTROL THE TYPE OF BOUNDARY ADJUSTMENT  */
    /*      RECOMMENDED VALUES ARE:   */
    /*           AL = 4 - 2 * SQRT(3),   AR = -4 + 2 * SQRT(3)   */
    /*  MAKE SURE THESE ARE SAME AS IN WVD4D.TST !!!!          */

  LOCAL N,M,CHIRAW,CLORAW,NHI,NLO,NHIL,NLOL,NHIR,NLOR,CEVEN,CODD,S,T,W,
      C2,C3,CNM2,CNM1,N,M,C,DENOM,Y,IS,J,NJ,IE,YOLD,R,YEVEN,YODD,Y1,YN ;

  N = ROWS(YR) + 2 ;
  M = LOG(N) ./ LOG(2) ;      /*  LOG BASE 2  */
  M = ROUND(M) ;

  IF ABS(2^M - N) > 10^(-10) ;
    "******************************************************" ;
    "***   CAREFUL n IS NOT A POWER OF 2, RETURNING 0   ***" ;
    "******************************************************" ;
   RETP(0) ;
  ENDIF ;

  CHIRAW = (-5+3*SQRT(3))|(9-5*SQRT(3))|(-3+SQRT(3))|(-1+SQRT(3)) ;
  CLORAW = (1+SQRT(3))|(3+SQRT(3))|(3-SQRT(3))|(1-SQRT(3)) ;

  NHI = SQRT(SUMC(CHIRAW^2)) ;
  NLO = SQRT(SUMC(CLORAW^2)) ;

  NHIL = SQRT(SUMC( (AL|CHIRAW[3 4])^2 )) ;
  NLOL = SQRT(SUMC( (((16-8*SQRT(3))/AL)|CLORAW[3 4])^2 )) ;

  NHIR = SQRT(SUMC( (CHIRAW[1 2]|AR)^2 )) ;
  NLOR = SQRT(SUMC( (CLORAW[1 2]|((-16+8*SQRT(3))/AR))^2 )) ;

  CEVEN = (3-SQRT(3))|(1+SQRT(3))|(-9-5*SQRT(3))|(1+SQRT(3)) ;
  CODD = (1-SQRT(3))|(3+SQRT(3))|(5+3*SQRT(3))|(3+SQRT(3)) ;

  S = -8 * SQRT(3) / ((1-SQRT(3)) + 8 * (5-3*SQRT(3)) / AL^2) ;
  T = -8 * (2-SQRT(3)) * S / AL^2 ;
  W = 8 + S * (3-SQRT(3)) + T * (-3+SQRT(3)) ;
  C2 = (S|(1+SQRT(3))|T|(1+SQRT(3))) / W ;

  S = -8 * SQRT(3) / ((3-SQRT(3)) + 8 * (9-5*SQRT(3)) / AL^2) ;
  T = -8 * (2-SQRT(3)) * S / AL^2 ;
  W = 24 + S * (1-SQRT(3)) + T * (-1+SQRT(3)) ;
  C3 = (S|(3+SQRT(3))|T|(3+SQRT(3))) / W ;

  S = 8 * SQRT(3) / ((3+SQRT(3)) + 8 * (33-19*SQRT(3)) / AR^2) ;
  T = 8 * (2-SQRT(3)) * S / AR^2 ;
  W = S * (1+SQRT(3)) + T * (-5+3*SQRT(3)) + 24 ;
  CNM2 = ((3-SQRT(3))|S|(-9-5*SQRT(3))|T) / W ;

  S = 8 * SQRT(3) / ((1+SQRT(3)) + 8 * (-19+11*SQRT(3)) / AR^2) ;
  T = 8 * (2-SQRT(3)) * S / AR^2 ;
  W = S * (3+SQRT(3)) + T * (9-5*SQRT(3)) + 8 ;
  CNM1 = ((1-SQRT(3))|S|(5+3*SQRT(3))|T) / W ;


  Y = YR[(N-7):(N-4),1] ;      /* START WITH 2nd TO LAST 4 VALUES  */
  IS = N - 3 ;

  J = M - 2 ;
  DO WHILE J >= 1 ;     /*  LOOP THROUGH LEVELS  */

    NJ = 2^(M-J) ;        /*  NUMBER OF VALUES INVERTED THIS STEP  */

    IE = IS - 1 ;         /*  LAST INDEX OF VALUES BEING INVERTED  */
    IS = IE - NJ + 1 ;    /*  FIRST INDEX OF VALUES BEING INVERTED  */

    YOLD = Y ;
    R = YR[IS:IE,2] ;      /*  NEXT SET OF R VALUES  */

    R = R .* (NHIL|(NHI*ONES(NJ-2,1))|NHIR) ;
    YOLD = YOLD .* (NLOL|(NLO*ONES(NJ-2,1))|NLOR) ;

    R = R[1:NJ-1,1]~R[2:NJ,1] ;
    YOLD = YOLD[1:NJ-1,1]~YOLD[2:NJ,1] ;

    YEVEN = ((YOLD[2:NJ-2,.]~R[2:NJ-2,.]) * CEVEN) / 32 ;
    YODD = ((YOLD[2:NJ-2,.]~R[2:NJ-2,.]) * CODD) / 32 ;
    YEVEN = ((YOLD[1,.]~R[1,.]) * C2)|YEVEN ;
    YODD = ((YOLD[1,.]~R[1,.]) * C3)|YODD ;
    YEVEN = YEVEN|((YOLD[NJ-1,.]~R[NJ-1,.]) * CNM2) ;
    YODD = YODD|((YOLD[NJ-1,.]~R[NJ-1,.]) * CNM1) ;

    Y1 = (R[1,1] - (-3+SQRT(3)) * YEVEN[1] - ((-1+SQRT(3)) * YODD[1])) / AL ;
    YN = R[NJ-1,2] - (-5+3*SQRT(3)) * YEVEN[NJ-1] ;
    YN = (YN - ((9-5*SQRT(3)) * YODD[NJ-1])) / AR ;
    YODD = Y1|YODD ;
    YEVEN = YEVEN|YN ;

    Y = RESHAPE(YODD~YEVEN,2*NJ,1) ;

    J = J - 1 ;
  ENDO ;

  RETP(Y) ;
ENDP ;
/* ============================ END PROC WVD4R ========================= */
