/* =========================== START PROC WVERTR1 ======================== */
PROC WVERTR1(MU,LAMBDA,J0,ITHRE) ;
    /*   FOR EXACT RISK ANALYSIS IN WAVELETS     */
    /*   THIS CALCULATES IAIN JOHNSTONE'S R FUNCTION     */
    /*   INPUTS ARE:     */
    /*     MU = THETA / SIG,    */
    /*          WHERE THETA ARE THE WAVELET COEFFS OF TARGET CURVE    */
    /*                       (VECTOR OF LENGTH N=2^JE)  */
    /*                (THIS IS MY MODIFIED VERSION, SINCE MY WAVELET    */
    /*                      TRANSFORM IS POWER PRESERVING)     */
    /*     LAMBDA = THRESHOLD VALUE   (E.G. SQRT(2LOGN))   */
    /*           CAN BE SCALAR, OR JE VECTOR   */
    /*     J0 = INDEX OF LOWEST FREQUENCY THRESHOLDED   */
    /*     ITHRE = 0   FOR 0 THRESHHOLDING (I.E. LO FREQ RECON.)   */
    /*           = 1   FOR HARD THRESHOLDING   */
    /*           = 2   FOR SOFT THRESHOLDING    */
    /*   OUTPUT IS  IAIN'S FUNCTION R(MU,LAMBDA)    */
    /*         AS AN N VECTOR WITH 0'S FOR FREQUENCIES LOWER  */
    /*         THAN THE J0 FREQUENCY     */

  LOCAL N,JE,VLAMBDA,ROUT,J,IS,IE,MUS,LAM,ROUTS ;

  N = ROWS(MU) ;
  JE = ROUND(LOG(N) / LOG(2)) ;

  IF ROWS(LAMBDA) == 1 ;    /*  INPUT WAS A SCALAR   */
    VLAMBDA = LAMBDA * ONES(JE,1) ;
  ELSE ;                    /*  INPUT ALREADY IN VECTOR FORM  */
    VLAMBDA = LAMBDA ;
  ENDIF ;

  ROUT = ZEROS(N,1) ;
  J = JE - 1 ;        /*  HAVE 2^J TERMS AT HIGHEST FREQUENCY  */
  DO WHILE J >= J0 ;    /*  LOOP STARTS BIG AND GETS SMALL  */
    IF J == JE - 1 ;
      IS = 1 ;
    ELSE ;
      IS = IE + 1 ;
    ENDIF ;
    IE = IS - 1 + 2^J ;

    MUS = MU[IS:IE] ;
    LAM = VLAMBDA[J] ;

    IF ITHRE == 0 ;      /*  0 THRESHOLDING, IE. LO FREQ RECONSTRUCT   */
      ROUTS = MUS^2 ;
    ELSEIF ITHRE == 1 ;  /*  HARD THRESHOLDING   */
      ROUTS = MUS^2 .* (CDFN(LAM - MUS) - CDFN(-LAM - MUS)) ;
      ROUTS = ROUTS + CDFNC(LAM - MUS) + CDFNC(LAM + MUS) ;
      ROUTS = ROUTS + (LAM - MUS) .* PDFN(LAM - MUS) ;
      ROUTS = ROUTS + (LAM + MUS) .* PDFN(LAM + MUS) ;
    ELSEIF ITHRE == 2 ;  /*  SOFT THRESHOLDING   */
      ROUTS = CDFN(LAM - MUS) - CDFN(-LAM - MUS) ;
      ROUTS = (MUS^2 - LAM^2 - 1) .* ROUTS ;
      ROUTS = ROUTS - (LAM - MUS) .* PDFN(LAM + MUS) ;
      ROUTS = ROUTS - (LAM + MUS) .* PDFN(LAM - MUS) ;
      ROUTS = 1 + LAM^2 + ROUTS ;
    ENDIF ;
    ROUT[IS:IE] = ROUTS ;

    J = J - 1 ;     /*  LOOP GOES DOWNWARDS  */
  ENDO ;

  RETP(ROUT) ;
ENDP ;
/* ============================ END PROC WVERTR1 ========================= */
