/* =========================== START PROC WVFFTD ======================== */
PROC WVFFTD(Y) ;
    /*  A FAST FOURIER TRANSFORM, EXCEPT MODIFIED TO:     */
    /*      1. BE POWER PRESERVING,                      */
    /*           (I.E. SUMS OF SQUARES OF FFT = THAT OF DATA)   */
    /*      2. HAVE OUPUT IS SAME FORM AS WV2D1.G        */
    /*           (I.E. A SINGLE COLUMN VECTOR, LOW FREQS 1ST)   */
    /*  INPUT VECTOR Y MUST BE REAL VALUED         */
    /*           AND ITS LENGTH MUST BE A POWER OF 2    */

  LOCAL N,RN,FFTY,RC,IC,OUT ;

  N = ROWS(Y) ;
  RN = SQRT(N) ;

  FFTY = RFFT(Y) ;
       /*  TURN OUTPUT OF YR INTO FREQUENCY ORDERED SET OF COEFFS  */
       /*  TWO COLUMNS, ESSENTIALLY FOR SIN AND COS  */

  OUT = FFTY[1] ;    /*  OVERALL AVERAGE   */

    RC = REAL(FFTY[2:N/2]) ;      /*  COEFFS OF COS'S  */
    IC = IMAG(FFTY[2:N/2]) ;      /*  COEFFS OF SIN'S  */
    RC = SQRT(2) * RC ;
    IC = SQRT(2) * IC ;
             /*  RESCALE, SINCE ARE ONLY USING ONE OF TWO  */
  OUT = OUT|RESHAPE(RC~IC,N-2,1) ;
                     /*  NEXT TERMS IN FREQUENCY ORDER  */
  OUT = OUT|FFTY[(N/2)+1] ;
                     /*  HIGHEST FREQUENCY TERM   */

  OUT = OUT * RN ;         /*  MAKE POWER PRESERVING  */

  OUT = REAL(OUT) ;     /*  AVOIDS SMALL COMPLEX PART   */

  RETP(OUT) ;
ENDP ;
/* ============================ END PROC WVFFTD ========================= */
