/* =========================== START PROC WVHD ======================== */
PROC WVHD(Y) ;
    /*  DOES "DECOMPOSITION STEP" IN HAAR WAVELET ESTIMATOR   */
    /*  Y IS VECTOR OF Y VALUES, WHERE CORRESPONDING X'S   */
    /*  ARE ASSUMED TO BE:   0,1,2,...,(2^M - 1)     (FOR SOME M)   */
    /*  I.E. NUMBERS ON ENTRIES IN Y NEEDS TO BE A POWER OF 2  */
    /*  OUTPUT IS A 2 COLUMN MATRIX,    */
    /*      THE FIRST COLUMN IS THE NEW "PREDICTED VALUES"   */
    /*      THE SECOND COLUMN IS THE "DISCREPANCIES"   */
    /*  GENERAL ALGORITHM STRUCTURE IS AN ADAPTATION OF THE IDEAS   */
    /*  IN BOCK (1992) STAT. COMP. AND STAT. GRA. NEWS., 3, 27-34.  */
    /*  COEFFICIENTS CHOSEN TO PRESERVE POWER OF SIGNAL  */

  LOCAL R2,N,M,NEWY,R,IS,IE,J,ISO,IEO,NJ,TEMPY ;

  R2 = SQRT(2) ;
  N = ROWS(Y) ;
  M = LOG(N) ./ LOG(2) ;      /*  LOG BASE 2  */
  M = ROUND(M) ;

  IF ABS(2^M - N) > 10^(-10) ;
    "******************************************************" ;
    "***   CAREFUL n IS NOT A POWER OF 2, RETURNING 0   ***" ;
    "******************************************************" ;
   RETP(0) ;
  ENDIF ;


  NEWY = ZEROS(N-1,1) ;
  R = ZEROS(N-1,1) ;

             /*  FIRST ITERATION USES RAW DATA  */
  IS = 1 ;
  IE = N/2 ;
  TEMPY = RESHAPE(Y,IE,2) ;
  NEWY[IS:IE] = (TEMPY[.,1] + TEMPY[.,2]) / R2 ;    /*  LO PASS FILTER  */
  R[IS:IE] = (TEMPY[.,1] - TEMPY[.,2]) / R2 ;	    /*  HI PASS FILTER  */

  J = 2 ;
  DO WHILE J <= M ;     /*  LOOP THROUGH LEVELS  */

    ISO = IS ;
    IEO = IE ;

    NJ = 2^(M-J) ;

    IS = IEO + 1 ;
    IF J < M ;
      IE = IS + NJ - 1 ;
    ELSE ;
      IE = IS ;
    ENDIF ;

    TEMPY = RESHAPE(NEWY[ISO:IEO],NJ,2) ;
    NEWY[IS:IE] = (TEMPY[.,1] + TEMPY[.,2]) / R2 ;  /*  LO PASS FILTER  */
    R[IS:IE] = (TEMPY[.,1] - TEMPY[.,2]) / R2 ;     /*  HI PASS FILTER  */

    J = J + 1 ;
  ENDO ;


  RETP(NEWY~R) ;
ENDP ;
/* ============================ END PROC WVHD ========================= */
