disp(['Running HeadNeckSurvival1.m']) ;
%  Does Preliminary Analysis of Head and Neck Squamous Cell TCGA Data
%  From Vonn Walter,   Dec. 18, 2014
%
%  Files from Vonn:
%        hnsc_rsem_n=497.txt
%        HNSC_FollowUpTimes_2_7_13.txt
%
%  These were turned into Excel files, for easy reading into Matlab,
%      but there was a misalignment in the latter.  This has now been 
%      fixed by adding a new first field "Names" + tab
%      into the first file.  Then Excel reread was done again
%
%  Note:  there was a problem with case names:
%      hnsc_rsem_n=497.txt                  used e.g.  TCGA.BA.4074
%      HNSC_FollowUpTimes_2_7_13.txt        used e.g.  TCGA-BA-4074
%  To fix this, the file HNSC_FollowUpTimes_2_7_13.xlsx
%      has been edited to use the "." format
%
%
%  Data are read in, and stored as:
%      HeadNeckSurvival1.mat
%  for remaining analyses
%
%
%
%


ipart = 4 ;    %  0 - Read in Raw Data, check, and save as .mat file
               %  1 - Summaries of Raw Gene Expression
               %  2 - Summaries of log transformed Gene Expression
               %  3 - Summaries of Survival Data
               %  4 - PCA views of gene expression


savefilestr = 'HeadNeckSurvival1' ;


if ipart == 0 ;    %  Read in Raw Data, check, and save as .mat file


  %  Read in Main Spreadsheet
  %
  [num,text] = xlsread('hnsc_rsem_n=497.xlsx') ;
  cCaseNames = text(1,2:end) ;
      %  1 x n cell array of Case Names
  disp('Check first Case Name is TCGA.CQ.7065') ;
  cCaseNames{1} 
  disp('Check last Case Name is TCGA.CQ.6218') ;
  cCaseNames{end} 

  cGeneNames = text(2:end,1) ;
      %  d x 1  cell array of Gene Names
  disp('Check first Gene Name is ?|100130426') ;
  cGeneNames{1} 
  disp('Check last Gene Name is tAKR|389932') ;
  cGeneNames{end} 

  mGenExp = num(1:end,1:end) ;
      %  d x n matrix of Gene Expression
  disp('Check top left Gene Expression value is 0') ;
  mGenExp(1,1) 
  disp('Check top right Gene Expression value is 0') ;
  mGenExp(1,end) 
  disp('Check 2nd left Gene Expression value is 9.2192') ;
  mGenExp(2,1) 
  disp('Check 2nd right Gene Expression value is 6.0093') ;
  mGenExp(2,end) 
  disp('Check bottom left Gene Expression value is 0') ;
  mGenExp(end,1) 
  disp('Check bottom right Gene Expression value is 0.4232') ;
  mGenExp(end,end) 

  d = size(mGenExp,1) ;
  n = size(mGenExp,2) ;


  %  Read in Survival Data
  %
  [num,text] = xlsread('HNSC_FollowUpTimes_2_7_13.xlsx') ;

  csCaseNames = text(2:end,1) ;
      %  1 x n cell array of Case Names, in survival file order
  disp('Check first Case Name is TCGA-BA-4074') ;
  csCaseNames{1} 
  disp('Check last Case Name is TCGA-IQ-7632') ;
  csCaseNames{end} 

  vsTime2Death = num(1:end,1) ;
      %  n x 1 vector of Time 2 Death, in survival file order
  disp('Check first Time 2 Death is 461') ;
  vsTime2Death(1) 
  disp('Check last Time 2 Death is 113') ;
  vsTime2Death(end) 

  vsDeathStatus = num(1:end,2) ;
      %  n x 1 vector of Death Status, in survival file order
  disp('Check first Death Status is 1') ;
  vsDeathStatus(1) 
  disp('Check last Death Status is 0') ;
  vsDeathStatus(end) 

  vsTime2Recur = num(1:end,3) ;
      %  n x 1 vector of Time 2 Recurrence, in survival file order
  disp('Check first Time 2 Death is NAN') ;
  vsTime2Recur(1) 
  disp('Check 8th Time 2 Death is 1522') ;
  vsTime2Recur(8) 
  disp('Check last Time 2 Death is NAN') ;
  vsTime2Recur(end) 

  vsRecurStatus = num(1:end,4) ;
      %  n x 1 vector of Recurrence Status, in survival file order
  disp('Check first Recurrence Status is 0') ;
  vsRecurStatus(1) 
  disp('Check 8th Recurrence Status is 1') ;
  vsRecurStatus(8) 
  disp('Check last Recurrence Status is 0') ;
  vsRecurStatus(end) 

  ns = length(vsTime2Death) ;
  disp('Check Number of Survival Time Points') ;
  ns
  disp(['Out of ' num2str(n) ' overall Cases']) ;


  % Create Versions of Survival Data, in order of Expression Data
  %
  vSurvFlag = zeros(1,n) ;
  vTime2Death = NaN * ones(1,n) ;
  vDeathStatus = NaN * ones(1,n) ;
  vTime2Recur = NaN * ones(1,n) ;
  vRecurStatus = NaN * ones(1,n) ;
      %  Use NaNs where have no Survival Data
  for i = 1:n ;

    CaseName = cCaseNames{i} ;
        %  current Case Name
    vflag = strcmp(CaseName,csCaseNames) ;
        %  1 where there is a match, 0s elsewhere
    if sum(vflag) == 0 ;
      disp(['          Unmatched CaseName: ' CaseName]) ;
    elseif sum(vflag) == 1 ;
      vSurvFlag(i) = 1 ;
      vTime2Death(i) = vsTime2Death(vflag) ;
      vDeathStatus(i) = vsDeathStatus(vflag) ;
      vTime2Recur(i) = vsTime2Recur(vflag) ;
      vRecurStatus(i) = vsRecurStatus(vflag) ;
    else ;
        disp('!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!') ;
        disp('!!!   Error from HeadNieckSurvival1.m    !!!') ;
        disp('!!!   Case Name appears twice            !!!') ;
        disp(['!!!   ' CaseName]) ;
        disp('!!!   Terminating Execution              !!!') ;
        return ;
    end ;

  end ;
  vSurvFlag = logical(vSurvFlag) ;
  disp(['Number Cases with Survival Data = ' num2str(sum(vSurvFlag))]) ;
  disp(['Number Deaths = ' num2str(sum(vDeathStatus == 1))]) ;
  disp(['Number Alive at End = ' num2str(sum(vDeathStatus == 0))]) ;
  disp(['Number Recurrences = ' num2str(sum(vRecurStatus == 1))]) ;


  %  Set up Patient Colors
  %
  mcolor = zeros(n,3) ;
  flagDeath = vSurvFlag & (vDeathStatus == 1) ;
  nDeath = sum(flagDeath') ;
  if nDeath > 0 ;
    mcolor(flagDeath,:) = ones(nDeath,1) * [1 0 0] ;
  end ;
  flagSurv = vSurvFlag & (vDeathStatus == 0) ;
  nSurv = sum(flagSurv') ;
  if nSurv > 0 ;
    mcolor(flagSurv,:) = ones(nSurv,1) * [0 0 1] ;
  end ;


  %  Save Main output file
  %
  save(savefilestr,'cCaseNames','cGeneNames','mGenExp','d','n', ...
           'vSurvFlag','vTime2Death','vDeathStatus', ...
           'vTime2Recur','vRecurStatus','mcolor') ;  


else ;    %  Read .mat file

  load(savefilestr) ;
      %  Loads variables:
      %      cCaseNames - Cell array of Case Names
      %      cGeneNames - d x 1 cell array of Gene Names
      %      mGenExp - d x n matrix of Gene Expression
      %      d - number of genes
      %      n - scalar overall total number of cases
      %      vSurvFlag - 1 x n logical vector for when have survival data
      %      vTime2Death - 1 x n vector of times
      %             to death for Death Status = 1
      %             to end of follow up for Death Status = 0
      %             NaN otherwise
      %      vDeathStatus - 1 x n vector of Death Status
      %      vTime2Recur - 1 x n vector of time to recurrence
      %             to death for Death Status = 1
      %             to end of follow up for Death Status = 0
      %             NaN otherwise
      %      vRecurStatus - 1 x n vector of Recurrence Status
      %      mcolor - matrix of colors:
      %                   blue  - No Death
      %                   red   - Death
      %                   black - no survival data

  mflagnan = isnan(mGenExp) ;
      %  matrix of flags for NaNs (missing values)
      %  this was originally defined at beginning of Figure 1, ipart = 1
      %  Another issue is genes with all 0 counts, so delete those as well
  mflag0 = (mGenExp == 0) ;
      %  matrix of flags for 0s (no measured gene expression)
      %  at least one gene has all 0's, which impacts summary measures
  vflagNm = ~(sum(mflagnan,2) > 0) & (sum(mflag0,2) < n) ;
      %  No NaNs & less than all 0s
  mGenExpNm = mGenExp(vflagNm,:) ;
  cGeneNamesNm = cGeneNames(vflagNm) ;
  dNm = sum(vflagNm) ;
  disp(['    Deleting ' num2str(d - dNm) ' genes with missing values or all 0s']) ;

  mGenExpLt = log10(mGenExpNm + 1) ;
      %  log transformed version of Gene Expression data set

  markerstr = [] ;
  for i = 1:n ;
    if vDeathStatus(i) == 1 ;
      markerstr = strvcat(markerstr,'x') ;
    elseif vDeathStatus(i) == 0 ;
      markerstr = strvcat(markerstr,'+') ;
    else ;
      markerstr = strvcat(markerstr,'o') ;
    end ;
  end ;


  if ipart == 1 ;    %  Summaries of Raw Gene Expression

    figure(1) ;    %  Found NaNs, so see where they are
    clf ;
    subplot(2,2,1) ;
      plot((1:d)',sum(mflagnan,2),'k-') ;
      title('Row Wise # of NANs') ;
      xlabel('Gene Index') ;
      ylabel('# NaNs') ;
    subplot(2,2,2) ;
      plot((1:n)',sum(mflagnan,1),'k-') ;
      title('Column Wise # of NANs') ;
      xlabel('Case Index') ;
      ylabel('# NaNs') ;
    subplot(2,2,3) ;    %  Found Genes with all 0s, so explore where they are
      vflag0 = sum(mflag0,2) ;
      vflag00 = (vflag0 == 0) ;
      vflag0n0 = vflag0(~vflag00) ;
      paramstruct = struct('ndatovlay',2, ...
                           'datovlaymax',0.9, ...
                           'datovlaymin',0.1, ...
                           'titlestr','KDE of Row Wise # of 0s (non-0)', ...
                           'xlabelstr','# 0s', ...
                           'ylabelstr','density') ;
      kdeSM(vflag0n0,paramstruct) ;
      hold on ;
        vax = axis ;
        text(vax(1) + 0.2 * (vax(2) - vax(1)), ...
             vax(3) + 0.9 * (vax(4) - vax(3)), ...
             ['Proportion of genes with no 0s = ' num2str(sum(vflag00) / d)]) ;
      hold off ;
    subplot(2,2,4) ;
      plot((1:100)',sum(mflag0(1:100,:),2),'k-') ;
      title('Row Wise # of 0s, 1st 100 Genes') ;
      xlabel('Gene Index') ;
      ylabel('# 0s') ;
    orient landscape ;
    savepre = [savefilestr 'ip' num2str(ipart) 'RawMissingGenes'] ;
    print('-dpsc2',savepre) ;
    %  These showed that 4 genes were NaNs for all cases, which motivated the 
    %  creation of the array mGenExpNm,  non-missing version of mGenExpNm, 
    %  non-missing version of data matrix

    figure (2) ;
    savepre = [savefilestr 'ip' num2str(ipart) 'MargDist'] ;
    titlecellstr = {{'' 'Head-Neck SC Survival' 'Raw Marginals - Mean Sorted' ...
                            ['n = ' num2str(n) '    d = ' num2str(dNm)]}} ;
    paramstruct = struct('istat',1, ...
                         'varnamecellstr',{cGeneNamesNm}, ...
                         'icolor',mcolor, ...
                         'isubpopkde',1, ...
                         'titlecellstr',titlecellstr, ...
                         'savestr',[savepre 'Raw01Means']) ;
    MargDistPlotSM(mGenExpNm,paramstruct) ;

    figure(3) ;
    clf ;
    savepre = [savefilestr 'ip' num2str(ipart) 'MargDist'] ;
    titlecellstr = {{'' 'Head-Neck SC Survival' 'Raw Marginals - SD Sorted' ...
                            ['n = ' num2str(n) '    d = ' num2str(dNm)]}} ;
    paramstruct = struct('istat',2, ...
                         'varnamecellstr',{cGeneNamesNm}, ...
                         'icolor',mcolor, ...
                         'isubpopkde',1, ...
                         'titlecellstr',titlecellstr, ...
                         'savestr',[savepre 'Raw02SDs']) ;
    MargDistPlotSM(mGenExpNm,paramstruct) ;

    figure(4) ;
    clf ;
    savepre = [savefilestr 'ip' num2str(ipart) 'MargDist'] ;
    titlecellstr = {{'' 'Head-Neck SC Survival' 'Raw Marginals - Skewness Sorted' ...
                            ['n = ' num2str(n) '    d = ' num2str(dNm)]}} ;
    paramstruct = struct('istat',3, ...
                         'varnamecellstr',{cGeneNamesNm}, ...
                         'icolor',mcolor, ...
                         'isubpopkde',1, ...
                         'titlecellstr',titlecellstr, ...
                         'savestr',[savepre 'Raw03Skewness']) ;
    MargDistPlotSM(mGenExpNm,paramstruct) ;

    figure(5) ;
    clf ;
    savepre = [savefilestr 'ip' num2str(ipart) 'MargDist'] ;
    titlecellstr = {{'' 'Head-Neck SC Survival' 'Raw Marginals - Kurtosis Sorted' ...
                            ['n = ' num2str(n) '    d = ' num2str(dNm)]}} ;
    paramstruct = struct('istat',4, ...
                         'varnamecellstr',{cGeneNamesNm}, ...
                         'icolor',mcolor, ...
                         'isubpopkde',1, ...
                         'titlecellstr',titlecellstr, ...
                         'savestr',[savepre 'Raw04Kurtosis']) ;
    MargDistPlotSM(mGenExpNm,paramstruct) ;

    figure(6) ;
    clf ;
    savepre = [savefilestr 'ip' num2str(ipart) 'MargDist'] ;
    titlecellstr = {{'' 'Head-Neck SC Survival' 'Raw Marginals - Max Sorted' ...
                            ['n = ' num2str(n) '    d = ' num2str(dNm)]}} ;
    paramstruct = struct('istat',9, ...
                         'varnamecellstr',{cGeneNamesNm}, ...
                         'icolor',mcolor, ...
                         'isubpopkde',1, ...
                         'titlecellstr',titlecellstr, ...
                         'savestr',[savepre 'Raw09Max']) ;
    MargDistPlotSM(mGenExpNm,paramstruct) ;

    figure(7) ;
    clf ;
    savepre = [savefilestr 'ip' num2str(ipart) 'MargDist'] ;
    titlecellstr = {{'' 'Head-Neck SC Survival' 'Raw Marginals - # Uniq Sorted' ...
                            ['n = ' num2str(n) '    d = ' num2str(dNm)]}} ;
    paramstruct = struct('istat',11, ...
                         'varnamecellstr',{cGeneNamesNm}, ...
                         'icolor',mcolor, ...
                         'isubpopkde',1, ...
                         'titlecellstr',titlecellstr, ...
                         'savestr',[savepre 'Raw11NumUniq']) ;
    MargDistPlotSM(mGenExpNm,paramstruct) ;

    figure(8) ;
    clf ;
    savepre = [savefilestr 'ip' num2str(ipart) 'MargDist'] ;
    titlecellstr = {{'' 'Head-Neck SC Survival' 'Raw Marginals - # 0s Sorted' ...
                            ['n = ' num2str(n) '    d = ' num2str(dNm)]}} ;
    paramstruct = struct('istat',13, ...
                         'varnamecellstr',{cGeneNamesNm}, ...
                         'icolor',mcolor, ...
                         'isubpopkde',1, ...
                         'titlecellstr',titlecellstr, ...
                         'savestr',[savepre 'Raw13Num0s']) ;
    MargDistPlotSM(mGenExpNm,paramstruct) ;

    figure(9) ;
    clf ;
    savepre = [savefilestr 'ip' num2str(ipart) 'MargDist'] ;
    titlecellstr = {{'' 'Head-Neck SC Survival' 'Raw Marginals - L3 Ratio Sorted' ...
                            ['n = ' num2str(n) '    d = ' num2str(dNm)]}} ;
    paramstruct = struct('istat',19, ...
                         'varnamecellstr',{cGeneNamesNm}, ...
                         'icolor',mcolor, ...
                         'isubpopkde',1, ...
                         'titlecellstr',titlecellstr, ...
                         'savestr',[savepre 'Raw19L3Ratio']) ;
    MargDistPlotSM(mGenExpNm,paramstruct) ;

    figure(10) ;
    clf ;
    savepre = [savefilestr 'ip' num2str(ipart) 'MargDist'] ;
    titlecellstr = {{'' 'Head-Neck SC Survival' 'Raw Marginals - L4 Ratio Sorted' ...
                            ['n = ' num2str(n) '    d = ' num2str(dNm)]}} ;
    paramstruct = struct('istat',20, ...
                         'varnamecellstr',{cGeneNamesNm}, ...
                         'icolor',mcolor, ...
                         'isubpopkde',1, ...
                         'titlecellstr',titlecellstr, ...
                         'savestr',[savepre 'Raw20L4Ratio']) ;
    MargDistPlotSM(mGenExpNm,paramstruct) ;


  elseif ipart == 2 ;    %  Summaries of log transformed Gene Expression

    figure (1) ;
    savepre = [savefilestr 'ip' num2str(ipart) 'MargDist'] ;
    titlecellstr = {{'' 'Head-Neck SC Survival' 'log10 Marginals - Mean Sorted' ...
                            ['n = ' num2str(n) '    d = ' num2str(dNm)]}} ;
    paramstruct = struct('istat',1, ...
                         'varnamecellstr',{cGeneNamesNm}, ...
                         'icolor',mcolor, ...
                         'isubpopkde',1, ...
                         'titlecellstr',titlecellstr, ...
                         'savestr',[savepre 'log01Means']) ;
    MargDistPlotSM(mGenExpLt,paramstruct) ;

    figure(2) ;
    clf ;
    savepre = [savefilestr 'ip' num2str(ipart) 'MargDist'] ;
    titlecellstr = {{'' 'Head-Neck SC Survival' 'log10 Marginals - SD Sorted' ...
                            ['n = ' num2str(n) '    d = ' num2str(dNm)]}} ;
    paramstruct = struct('istat',2, ...
                         'varnamecellstr',{cGeneNamesNm}, ...
                         'icolor',mcolor, ...
                         'isubpopkde',1, ...
                         'titlecellstr',titlecellstr, ...
                         'savestr',[savepre 'log02SDs']) ;
    MargDistPlotSM(mGenExpLt,paramstruct) ;

    figure(3) ;
    clf ;
    savepre = [savefilestr 'ip' num2str(ipart) 'MargDist'] ;
    titlecellstr = {{'' 'Head-Neck SC Survival' 'log10 Marginals - Skewness Sorted' ...
                            ['n = ' num2str(n) '    d = ' num2str(dNm)]}} ;
    paramstruct = struct('istat',3, ...
                         'varnamecellstr',{cGeneNamesNm}, ...
                         'icolor',mcolor, ...
                         'isubpopkde',1, ...
                         'titlecellstr',titlecellstr, ...
                         'savestr',[savepre 'log03Skewness']) ;
    MargDistPlotSM(mGenExpLt,paramstruct) ;

    figure(4) ;
    clf ;
    savepre = [savefilestr 'ip' num2str(ipart) 'MargDist'] ;
    titlecellstr = {{'' 'Head-Neck SC Survival' 'log10 Marginals - Kurtosis Sorted' ...
                            ['n = ' num2str(n) '    d = ' num2str(dNm)]}} ;
    paramstruct = struct('istat',4, ...
                         'varnamecellstr',{cGeneNamesNm}, ...
                         'icolor',mcolor, ...
                         'isubpopkde',1, ...
                         'titlecellstr',titlecellstr, ...
                         'savestr',[savepre 'log04Kurtosis']) ;
    MargDistPlotSM(mGenExpLt,paramstruct) ;

    figure(5) ;
    clf ;
    savepre = [savefilestr 'ip' num2str(ipart) 'MargDist'] ;
    titlecellstr = {{'' 'Head-Neck SC Survival' 'log10 Marginals - Max Sorted' ...
                            ['n = ' num2str(n) '    d = ' num2str(dNm)]}} ;
    paramstruct = struct('istat',9, ...
                         'varnamecellstr',{cGeneNamesNm}, ...
                         'icolor',mcolor, ...
                         'isubpopkde',1, ...
                         'titlecellstr',titlecellstr, ...
                         'savestr',[savepre 'log09Max']) ;
    MargDistPlotSM(mGenExpLt,paramstruct) ;

    figure(6) ;
    clf ;
    savepre = [savefilestr 'ip' num2str(ipart) 'MargDist'] ;
    titlecellstr = {{'' 'Head-Neck SC Survival' 'log10 Marginals - # Uniq Sorted' ...
                            ['n = ' num2str(n) '    d = ' num2str(dNm)]}} ;
    paramstruct = struct('istat',11, ...
                         'varnamecellstr',{cGeneNamesNm}, ...
                         'icolor',mcolor, ...
                         'isubpopkde',1, ...
                         'titlecellstr',titlecellstr, ...
                         'savestr',[savepre 'log11NumUniq']) ;
    MargDistPlotSM(mGenExpLt,paramstruct) ;

    figure(7) ;
    clf ;
    savepre = [savefilestr 'ip' num2str(ipart) 'MargDist'] ;
    titlecellstr = {{'' 'Head-Neck SC Survival' 'log10 Marginals - # 0s Sorted' ...
                            ['n = ' num2str(n) '    d = ' num2str(dNm)]}} ;
    paramstruct = struct('istat',13, ...
                         'varnamecellstr',{cGeneNamesNm}, ...
                         'icolor',mcolor, ...
                         'isubpopkde',1, ...
                         'titlecellstr',titlecellstr, ...
                         'savestr',[savepre 'log13Num0s']) ;
    MargDistPlotSM(mGenExpLt,paramstruct) ;

    figure(8) ;
    clf ;
    savepre = [savefilestr 'ip' num2str(ipart) 'MargDist'] ;
    titlecellstr = {{'' 'Head-Neck SC Survival' 'log10 Marginals - L3 Ratio Sorted' ...
                            ['n = ' num2str(n) '    d = ' num2str(dNm)]}} ;
    paramstruct = struct('istat',19, ...
                         'varnamecellstr',{cGeneNamesNm}, ...
                         'icolor',mcolor, ...
                         'isubpopkde',1, ...
                         'titlecellstr',titlecellstr, ...
                         'savestr',[savepre 'log19L3Ratio']) ;
    MargDistPlotSM(mGenExpLt,paramstruct) ;

    figure(9) ;
    clf ;
    savepre = [savefilestr 'ip' num2str(ipart) 'MargDist'] ;
    titlecellstr = {{'' 'Head-Neck SC Survival' 'log10 Marginals - L4 Ratio Sorted' ...
                            ['n = ' num2str(n) '    d = ' num2str(dNm)]}} ;
    paramstruct = struct('istat',20, ...
                         'varnamecellstr',{cGeneNamesNm}, ...
                         'icolor',mcolor, ...
                         'isubpopkde',1, ...
                         'titlecellstr',titlecellstr, ...
                         'savestr',[savepre 'log20L4Ratio']) ;
    MargDistPlotSM(mGenExpLt,paramstruct) ;


  elseif ipart == 3 ;    %  Summaries of Survival Data


  elseif ipart == 4 ;    %  PCA views of gene expression

    figure(1) ;
    clf ;
    savepre = [savefilestr 'ip' num2str(ipart) 'PCAscores'] ;
    titlecellstr = {{'Head-Neck SC Survival' 'log10 Transformed' ...
                            'Missing and all 0 genes deleted', ...
                            ['n = ' num2str(n) '    d = ' num2str(dNm)]}} ;
    paramstruct = struct('npcadiradd',4, ...
                         'iorient',1, ...
                         'icolor',mcolor, ...
                         'markerstr',markerstr, ...
                         'isubpopkde',1, ...
                         'titlecellstr',titlecellstr, ...
                         'savestr',[savepre], ...
                         'iscreenwrite',1) ;
    scatplotSM(mGenExpLt,[],paramstruct) ;

    figure(2) ;
    clf ;
    savepre = [savefilestr 'ip' num2str(ipart) 'PCAscores'] ;
    titlecellstr = {{'Head-Neck SC Survival' 'log10 Transformed' ...
                            'All with Survival Data', ...
                            ['n = ' num2str(sum(vSurvFlag)) '    d = ' num2str(dNm)]}} ;
    paramstruct = struct('npcadiradd',4, ...
                         'iorient',1, ...
                         'icolor',mcolor(vSurvFlag',:), ...
                         'markerstr',markerstr(vSurvFlag'), ...
                         'isubpopkde',1, ...
                         'titlecellstr',titlecellstr, ...
                         'savestr',[savepre 'HaveSurvDat'], ...
                         'iscreenwrite',1) ;
    scatplotSM(mGenExpLt(:,vSurvFlag),[],paramstruct) ;

    dirvec = DWD2XQ(mGenExpLt(:,(vDeathStatus == 1)),mGenExpLt(:,(vDeathStatus == 0))) ;

    figure(3) ;
    clf ;
    savepre = [savefilestr 'ip' num2str(ipart) 'DWDnOrthoPCA'] ;
    titlecellstr = {{'Head-Neck SC Survival' 'log10 Transformed' ...
                            'Survival DWD direction'}} ;
    paramstruct = struct('npcadiradd',-1, ...
                         'iorient',1, ...
                         'icolor',mcolor(vSurvFlag',:), ...
                         'markerstr',markerstr(vSurvFlag'), ...
                         'isubpopkde',1, ...
                         'titlecellstr',titlecellstr, ...
                         'savestr',[savepre 'HaveSurvDat'], ...
                         'iscreenwrite',1) ;
    scatplotSM(mGenExpLt(:,vSurvFlag),dirvec,paramstruct) ;

    figure(4) ;
    clf ;
    [sdirvec, vind] = sort(dirvec) ;
    savepre = [savefilestr 'ip' num2str(ipart) 'DWDloadings'] ;
    plot((1:dNm)',sdirvec,'g-','LineWidth',3) ;
    hold on ;
      plot([1; dNm],[0; 0],'k--') ;
    hold off ;
    vax = axisSM(sdirvec) ;
    axis([0 (dNm + 1) vax(1) vax(2)]) ;
    title(['Head & Neck SC, Gene Expression, Loadings of DWD on Survival']) ;
    ylabel('DWD Loading')
    orient landscape ;
    print('-dps2c',savepre) ;

    adirvec = abs(dirvec) ;
    [sadirvec,vind] = sort(adirvec) ;
    flag = adirvec > sadirvec(dNm - 50) ;

    figure(5) ;
    clf ;
    savepre = [savefilestr 'ip' num2str(ipart) 'DWDloadingsBarPlot'] ;
    titlestr = ['Head & Neck SC, Gene Expression, Loadings of DWD on Survival, Top 50'] ;
    paramstruct = struct('isort',1, ...
                         'fontsize',10, ...
                         'titlestr',titlestr, ...
                         'savestr',savepre) ;
    LabeledBarPlotSM(dirvec(flag),cGeneNamesNm(flag),paramstruct) ;

    %  Print gene list
    %
    [temp,vind] = sort(dirvec(flag)) ;
    scGnames = cGeneNamesNm(flag) ;
    scGnames = scGnames(vind) ;
    savepre = [savefilestr 'ip' num2str(ipart) 'DWDloadingsGeneNames.txt'] ;
    fid = fopen(savepre,'wt') ;
          %  'wt' is for "delete contents of this file and open 
          %               for writing" (with 't' for "text").
          %  Use 'ay' to append to what is already there, 'rt' for reading.
    titlstr1 = 'Output from the MATLAB Script HeadNeckSurvival1.m,   ' ;
    titlstr1 = [titlstr1,date] ;
    cntbytes = fprintf(fid,'%1s\n',titlstr1) ;
          %  '%1s/n' says "print string, followed by a line feed"
          %       (Note, this only goes to next line)
    titlstr2 = ['  ipart = ' num2str(ipart) ',  n = ' num2str(sum(vSurvFlag)) ...
                     ',  d = ' num2str(dNm) ...
                     ',  Biggest Genes in terms of DWD Loading'] ;
    cntbytes = fprintf(fid,'%1s\n\n\n',titlstr2) ;
          %  3 line feeds gives two blank lines
    titlstr3 = '    Gene Name' ;
    cntbytes = fprintf(fid,'%1s\n',titlstr3) ;
    for i = 1:sum(flag) ;
      cntbytes = fprintf(fid,'%1s\n',scGnames{i}) ;
    end ;
    fclose(fid) ;

    figure(6) ;
    clf ;
    savepre = [savefilestr 'ip' num2str(ipart) 'DiProPerm-MD-MD'] ;
    paramstruct = struct('idir',2, ...
                         'icolor',[[1 0 0]; [0 0 1]], ...
                         'markerstr',['x'; '+'], ...
                         'legendcellstr',{{'Died' 'Survived'}}, ...
                         'savestr',[savepre], ...
                         'iscreenwrite',1) ;
    DiProPermSM(mGenExpLt(:,(vDeathStatus == 1)), ...
                mGenExpLt(:,(vDeathStatus == 0)),paramstruct) ;

    figure(7) ;
    clf ;
    savepre = [savefilestr 'ip' num2str(ipart) 'DiProPerm-DWD-MD'] ;
    paramstruct = struct('icolor',[[1 0 0]; [0 0 1]], ...
                         'markerstr',['x'; '+'], ...
                         'legendcellstr',{{'Died' 'Survived'}}, ...
                         'savestr',[savepre], ...
                         'iscreenwrite',1) ;
    DiProPermSM(mGenExpLt(:,(vDeathStatus == 1)), ...
                mGenExpLt(:,(vDeathStatus == 0)),paramstruct) ;




  end ;    %  of inner ipart loop


end ;    %  of outer ipart loop




