function sss1slider(vh,ivitype)
% SSS1SLIDER, Function for SSS1, this creates graphics stuff for slider plot
%     Intended to be used by SSS1

%    Copyright (c) J. S. Marron 1999


global GRAPHHAND SLIMOV VLOG10H CURRENTH SLIDERHAND STITLEHAND SSSSTR ;
          %  GRAPHHAND - Handle to Figure 
          %  SLIMOV - slider's movie matrix
          %  VLOG10H - vector of log10 bandwidths
          %  CURRENTH - current value of bandwidth for slider
          %  SLIDERHAND - Handle for Slider (to get value)
          %  STITLEHAND - Handle for Title of Slider (showing bandwidth value)
          %  SSSSTR - String for type of SSS that is running






nh = length(vh) ;

%  Get Screensize
%
ScreenSize = get(0,'ScreenSize') ;
          %  4-vector of screensize in pixels
screenwd = ScreenSize(3) ;
          %  screen width
screenht = ScreenSize(4) ;
          %  screen height

%  resize figure for slider plot
%
  fxs = 0.40 * screenwd ;
          %  figure window x coord starting point
  fxl = 0.55 * screenwd ;
          %  figure window x coord length
  fys = 0.10 * screenht ;
          %  figure window x coord starting point
  fyl = 0.8 * screenht ;
          %  figure window x coord length
if ~isempty(GRAPHHAND) ;
  figure(GRAPHHAND(length(GRAPHHAND))) ;
          %  make the given figure current
end ;
set(gcf,'Position',[fxs,fys,fxl,fyl]) ;
          %  set position for current figure window


%  reposition axes to make room for slider
%
  axs = 0.1 ;
  axl = 0.8 ;
  ays = 0.25 ;
  ayl = 0.65 ;
axes('Position',[axs, ays, axl, ayl]) ;


VLOG10H = log10(vh) ;
CURRENTH = 10^mean([VLOG10H(1),VLOG10H(nh)]) ;
SSSSTR = ['SSS ' num2str(ivitype(1)) num2str(ivitype(2))] ;


%  Create bandwidth slider
  sxs = 0.1 * 0.55 * screenwd ;
  sxl = 0.8 * 0.55 * screenwd ;
  sys = 0.6 * 0.10 * screenht ;
  syl = 0.25 * 0.10 * screenht ;
  smallstep = VLOG10H(2) - VLOG10H(1) ;
          %  one step on slider scale
  bigstep = VLOG10H(10) - VLOG10H(1) ;
          %  five steps on slider scale
SLIDERHAND = uicontrol(gcf,'Style','slider', ...
                     'Position',[sxs,sys,sxl,syl],  ...
                     'Min',VLOG10H(1), ...
                     'Max',VLOG10H(nh), ...
                     'Value',log10(CURRENTH), ...
                     'SliderStep',[smallstep, bigstep], ...
                     'CallBack','sss1slidercb') ;

%  Create Title for slider (showing value of CURRENTH)
%
  stxs = 0.35 * 0.55 * screenwd ;
  stxl = 0.3 * 0.55 * screenwd ;
  stys = 1.0 * 0.10 * screenht ;
  styl = 0.2 * 0.10 * screenht ;
  tstr = [SSSSTR ', h = ' num2str(CURRENTH)] ;
STITLEHAND = uicontrol(gcf,'Style','text', ...
                     'Position',[stxs,stys,stxl,styl], ...
                     'BackgroundColor', [0 0 0], ...
                     'ForegroundColor', [1 1 1], ...
                     'FontSize',12, ...
                     'String',tstr) ;

%  Create menu for printing current pic
%
pulldownmenu = uimenu(gcf,'Label','Print') ;
          %  attach main menu
printmenu = uimenu(pulldownmenu,'Label','Print current pic', ...
                     'CallBack','sss1sliderpr') ;
          %  Calls subroutine for printing current image





