function sss1slidercb ;
% SSS1SLIDERCB, Slider Callback String for SSS1
%    Copyright (c) J. S. Marron 1999

global GRAPHHAND A3DSLIMOV SLIMOV VLOG10H CURRENTH ;
          %  GRAPHHAND - Vector of Handles to Figures 
          %  A3DSLIMOV - 3d array of slider movie matrices
          %  SLIMOV - slider's movie matrix
          %  VLOG10H - vector of log10 bandwidths
          %  CURRENTH - current value of bandwidth for slider
global VSLIDERHAND SLIDERHAND VSTITLEHAND STITLEHAND SSSSTR ;
          %  VSLIDERHAND - Vector of Handles to all Sliders
          %  SLIDERHAND - Handle for Slider (to get value)
          %  VSTITLEHAND - Vector of Handles for Title of Slider
          %  STITLEHAND - Handle for Title of Slider (showing bandwidth value)
          %  SSSSTR - String for type of SSS that is running


if ~isempty(GRAPHHAND) ;   %  if there is a specified figure handle

  ifig = find(GRAPHHAND == gcf) ;
          %  index in GRAPHHAND of the current figure

  figure(GRAPHHAND(ifig)) ;

  SLIMOV = A3DSLIMOV(:,:,ifig) ;
  SLIDERHAND = VSLIDERHAND(ifig) ;
  STITLEHAND = VSTITLEHAND(ifig) ;

end ;





nh = length(VLOG10H) ;
          %  number of bandwidths in grid

lh = get(SLIDERHAND,'Value') ;
          %  get current log h value

ilh = (lh - VLOG10H(1)) / (VLOG10H(nh) - VLOG10H(1)) ;
          %  map current lh to [0,1] 
ilh = 1 + (nh - 1) * ilh ;
          %  map current lh to 1,nh
ilh = round(ilh) ;
          %  map curent lh to an integer 1,...,nh

CURRENTH = 10^VLOG10H(ilh) ;
          %  update current h


%  Show requested frame of the movie
%
colormap(gray) ;
movie(gca,SLIMOV(:,ilh)) ;



%  update slider title string
%
  tstr = [SSSSTR ', h = ' num2str(CURRENTH)] ;
set(STITLEHAND,'String',tstr) ;


