function sss1sliderpr ;
% SSS1SLIDERPR, Does PRint of current Slider controlled image, in SSS1
%    Copyright (c) J. S. Marron 1999

global GRAPHHAND SLIMOV VLOG10H CURRENTH SSSSTR ;
          %  GRAPHHAND - Handle to Figure 
          %  SLIMOV - slider's movie matrix
          %  VLOG10H - vector of log10 bandwidths
          %  CURRENTH - current value of bandwidth for slider
          %  SSSSTR - String for type of SSS that is running


if ~isempty(GRAPHHAND) ;   %  if there is a specified figure handle
  figure(GRAPHHAND) ;
end ;


typestr = SSSSTR(5:6) ;

tstr = [SSSSTR ', h = ' num2str(CURRENTH)] ;


nh = length(VLOG10H) ;
          %  number of bandwidths in grid
lh = log10(CURRENTH) ;
          %  get current log h value
ilh = (lh - VLOG10H(1)) / (VLOG10H(nh) - VLOG10H(1)) ;
          %  map current lh to [0,1] 
ilh = 1 + (nh - 1) * ilh ;
          %  map current lh to 1,nh
ilh = round(ilh) ;
          %  map current lh to an integer 1,...,nh


%  Create version of this movie that will print
%
origfighand = gcf ;

vpos = get(origfighand,'Position') ;
          %  vector of positions for original SSS plot
          %  (use this for new plot to get aspect ratio right)

whitebg('w') ;
          %  set background color to white


colormap(gray) ;
movie(gca,SLIMOV(:,ilh)) ;
          %  do replot of pic, to get right colors


capture ;
          %  creates bitmap of image in current figure,
          %  and puts it in the next figure

set(gcf,'Position',vpos) ;
          %  reset screen position, to get right aspect ratio

papyl = 8 * (vpos(4) / vpos(3)) ;
papys = (11 - papyl) / 2 ;
vpappos = [.25 papys 8 papyl] ;
set(gcf,'PaperPosition',vpappos) ;


%  Print
%

eval(['print -dpsc \matlab\steve\ps\sss1sl' typestr ...
                          num2str(ilh) '.ps ;']) ;



%  Reset stuf in main slider window
%
figure(origfighand) ;
          %  bring original graphic (with real ui controls)
          %  to the top

whitebg('k') ;
          %  set background color to white

colormap(gray) ;
movie(gca,SLIMOV(:,ilh)) ;
          %  do replot of pic, to get right colors


disp('    Finished Printing this Image') ;
