disp('Running MATLAB script file UNC2000Link0.m') ;
%
%    For resaving subsets of Don Smith's 
%    UNC Main Link 2000 data sets 
%        (in the directory RawData)
%         092400_0830_in_http.txt
%         092400_0830_in_ip.txt
%         092400_0830_in_tcp.txt
%         092600_1600_in_http.txt
%         092600_1600_in_ip.txt
%         092600_1600_in_tcp.txt
%    of 5 million packet time stamps and sizes
%    into files with the 1st nkeep = 2 million,
%         UNC2000LinkOffHTTP.mat
%         UNC2000LinkOffIP.mat
%         UNC2000LinkOffTCP.mat
%         UNC2000LinkPeakHTTP.mat
%         UNC2000LinkPeakIP.mat
%         UNC2000LinkPeakTCP.mat
%        (in the directory:  MatlabData)
%
%    Or for binning to 2^20 (~1 million) bins


ipart = 3 ;    %  1 - read big data files and save
               %  2 - test time to read in matlab files
               %  3 - bin counts to 2^20 (~1 million) bins
               %  4 - bin packet sizes to 2^20 (~1 million) bins
               %           (not ready yet)
               %  5 - eventually do something about 
               %          coarse scale binning????


vifile = [1 2 3 4 5 6] ;   
vifile = [2 5] ;   
               %  1 - 092400_0830_in_http.txt
               %  2 - 092400_0830_in_ip.txt
               %  3 - 092400_0830_in_tcp.txt
               %  4 - 092600_1600_in_http.txt
               %  5 - 092600_1600_in_ip.txt
               %  6 - 092600_1600_in_tcp.txt



nkeep = 2 * 10^6 ;


addpath \matlab\stevesmo 



for ifile = vifile ;

  afilepre = '\matlabR12\work\NetWorkData\UNCLink2000\RawData\' ;
  mfilepre = '\matlabR12\work\NetWorkData\UNCLink2000\MatlabData\' ;

  if ifile == 1 ;
    afile = ['092400_0830_in_http.txt'] ;
    mfile = ['UNC2000LinkOffHTTP'] ;
    maintitstr = 'UNC main link 2000' ;
    intitstr = 'incoming' ;
    peaktitstr = 'Off Peak' ;
    typetitstr = 'http' ;

  elseif ifile == 2 ;
    afile = ['092400_0830_in_ip.txt'] ;
    mfile = ['UNC2000LinkOffIP'] ;
    maintitstr = 'UNC main link 2000' ;
    intitstr = 'incoming' ;
    peaktitstr = 'Off Peak' ;
    typetitstr = 'ip' ;

  elseif ifile == 3 ;
    afile = ['092400_0830_in_tcp.txt'] ;
    mfile = ['UNC2000LinkOffTCP'] ;
    maintitstr = 'UNC main link 2000' ;
    intitstr = 'incoming' ;
    peaktitstr = 'Off Peak' ;
    typetitstr = 'tcp' ;

  elseif ifile == 4 ;
    afile = ['092600_1600_in_http.txt'] ;
    mfile = ['UNC2000LinkPeakHTTP'] ;
    maintitstr = 'UNC main link 2000' ;
    intitstr = 'incoming' ;
    peaktitstr = 'Peak' ;
    typetitstr = 'http' ;

  elseif ifile == 5 ;
    afile = ['092600_1600_in_ip.txt'] ;
    mfile = ['UNC2000LinkPeakIP'] ;
    maintitstr = 'UNC main link 2000' ;
    intitstr = 'incoming' ;
    peaktitstr = 'Peak' ;
    typetitstr = 'ip' ;

  elseif ifile == 6 ;
    afile = ['092600_1600_in_tcp.txt'] ;
    mfile = ['UNC2000LinkPeakTCP'] ;
    maintitstr = 'UNC main link 2000' ;
    intitstr = 'incoming' ;
    peaktitstr = 'Peak' ;
    typetitstr = 'tcp' ;

  end ;    %  of i file number if-block


  afilestr = [afilepre afile] ;
  mfilestr = [mfilepre mfile] ;




  if ipart == 1 ;    %  then read big data files, cut down, and save


    %  Read ASCII file
    %
    tic ;
      fid = fopen(afilestr,'rt') ;
          %  'rt' is for "read only" and "text"
        fstr = '%f' ;
        [data,cnt] = fscanf(fid,fstr) ;
      fclose('all') ;

      data = reshape(data,2,length(data)/2)' ;
          %  turn into big two column matrix

    readtime = toc ;


    disp(['    For ' maintitstr ', ' intitstr ...
                ', ' peaktitstr ', ' typetitstr ':']) ;
    disp(['      ASCII read time was: ' num2str(readtime) ' secs']) ;
    disp(' ') ;

%size(data)
%data(1:4,1:2)
%gppause
          %  used these to check data read



    %  truncate data
    %
    if size(data,1) > nkeep ;
      data = data(1:nkeep,:) ;
    end ;



    %  Save as Matlab file
    %
    eval(['save ' mfilestr ' data ;']) ;



    data = [] ; 
          %  to save space



  elseif ipart == 2 ;    %  then time read of Matlab files

    data = [] ;


    tic ;
      eval(['load ' mfilestr]) ;
    readtime = toc ;


    disp(['    For ' maintitstr ', ' intitstr ...
                ', ' peaktitstr ', ' typetitstr]) ;
    disp(['      ASCII read time was: ' num2str(readtime) 'secs']) ;
    disp(' ') ;



  elseif ipart == 3 ;    %  then time read of Matlab files
   

    %  Read ASCII file
    %
    tic ;
      fid = fopen(afilestr,'rt') ;
          %  'rt' is for "read only" and "text"
        fstr = '%f' ;
        [data,cnt] = fscanf(fid,fstr) ;
      fclose('all') ;

      data = reshape(data,2,length(data)/2)' ;
          %  turn into big two column matrix

    readtime = toc ;


    disp(['    For ' maintitstr ', ' intitstr ...
                ', ' peaktitstr ', ' typetitstr ':']) ;
    disp(['      ASCII read time was: ' num2str(readtime) ' secs']) ;
    disp(' ') ;

%size(data)
%data(1:4,1:2)
%gppause
          %  used these to check data read

          
          
    % cutoff packet sizes, and move to time 0
    %
    data = data(:,1) ;
    data = data - data(1) ;

    

    %  bin the data
    %
    left = min(data) ;
    right = max(data) ;
    nbin = 2^20 ;    %  approx. 1 million
    bincts = gplbinr(data,[left,right,nbin]) ;


    
    %  Save as Matlab file
    %
    eval(['save ' mfilestr 'bin bincts left right nbin ;']) ;



    data = [] ; 
          %  to save space





  end ;    %  of ipart if-block



end ;    %  of i loop through files





