disp('Running MATLAB script file SiCur1fig4.m') ;
%
%    Makes Figure 4 for the SIgnificance of CURvature paper
%
%    Copied from Old\SiConToyEG1.m
%
%    This analyzes a carefully chosen Flow Cytometry Data set



pstr = 'SiCur1fig4' ;



figh = figure(1) ;
clf ;


%  Read in data
%
idat = 2 ;     %  1 - ELU
               %  2 - LNU
               %  3 - TH
if idat == 1 ; 
  infilestr = 'FloCytELU.txt' ;
  savestr = 'ELU' ;
elseif idat == 2 ; 
  infilestr = 'FloCytLNU.txt' ;
  savestr = 'LNU' ;
elseif idat == 3 ; 
  infilestr = 'FloCytTH.txt' ;
  savestr = 'TH' ;
end ;
infilestr = ['\Research\Bioinf\FlowCyt\' infilestr] ;

xstr = 'channel' ;
ystr = 'sqrt(counts)' ;

fid = fopen(infilestr,'rt');
mdata = fscanf(fid,'%f') ;
mdata = reshape(mdata,14,256)' ;
          %  since reshape works column wise
mdata = sqrt(mdata) ;

icol = 6 ;
vdata = mdata(:,icol) ;
nbin = length(vdata) ;



%  do SiZer analysis
%
paramstruct = struct('iout',2,...
                     'imovie',0,...
                     'hhighlight',-1,...
                     'ibigdot',1,...
                     'famoltitle',[],...
                     'sizertitle',[],...
                     'curvsizertitle',[],...
                     'xlabelstr',xstr,...
                     'ylabelstr',ystr,...
                     'labelfontsize',12,...
                     'ibdryadj',0,...
                     'iscreenwrite',1) ;

sizerSM([(1:nbin)' vdata],paramstruct) ;





  orient portrait ;
  set(gcf,'PaperSize',[5.0, 9.0]) ; 
  set(gcf,'PaperPosition',[0.25, 0.25, 4.5, 8.5]) ; 
print('-dpsc', [pstr '.ps']) ;


