disp('Running MATLAB script file SSScntr1Fig1n.m') ;
%
%    Creates Figure 1 for the paper on the 
%    Contour version of Significance in Scale Space
%    Revised version
%
%    This is about the SiZer analysis of the flow cytomtery data, 
%    discussed at the web site:
%    http://www.stat.unc.edu/faculty/marron/DataAnalyses/SiZer/SiZer_Examples.html#Eg2:FlowCytometry


addpath \DellInspiron7000\matlab\stevefun ;
addpath \DellInspiron7000\matlab\stevesmo ;


icol = 10 ;
    %  gave interesting results on web page



%  Read in flow cytometry data
%
fid = fopen('\Research\BioInf\FlowCyt\FloCytELU.TXT','rt');
mdata = fscanf(fid,'%f') ;
mdata = reshape(mdata,14,256)' ;
          %  since reshape works column wise
mdata = sqrt(mdata) ;
vdata = mdata(:,icol) ;




%  Set up graphics
%
close all ;
figure(1) ;
clf ;
set(gcf,'Position',[240 100 300 650]) ;



xstr = 'channel' ;
ystr = 'sqrt(counts)' ;




subplot(3,1,1) ;    %  square root counts histogram
  titstr = 'Flow Cytometry Histogram' ;

  top = 1.05 * max(vdata) ;
  left = 0.5 ;
  right = length(vdata) + 0.5 ;


  bh = bar(vdata) ;
    axis([left,right,0,top]) ;
    title(titstr) ;
    ylabel('sqrt(counts)') ;
  set(bh,'FaceColor',[0.5 0.5 0.5]) ;


subplot(3,1,2) ;    %  family plot
  paramstruct = struct('iout',4, ...
                       'imovie',0, ...
                       'icolor',0, ...
                       'hhighlight',0, ...
                       'famoltitle','Scale-Space Overlay', ...
                       'ylabelstr',ystr, ...
                       'iscreenwrite',1) ;

%  sizer2([(1:256)',vdata],paramstruct) ;
  sizerSM([(1:256)',vdata],paramstruct) ;



subplot(3,1,3) ;    %  SiZer map
  paramstruct = struct('iout',6, ...
                       'imovie',0, ...
                       'icolor',0, ...
                       'xlabelstr',xstr, ...
                       'ihhighlight',0, ...
                       'iscreenwrite',1) ;

%  sizer2([(1:256)',vdata],paramstruct) ;
  sizerSM([(1:256)',vdata],paramstruct) ;





%  Save graph as .eps file
%
vpos = get(gcf,'Position') ;
ht2wdrat = vpos(4) / vpos(3) ;
          %  height to width ratio
paperwd = 4.5 ;
          %  width of image on paper (inches)
paperht = ht2wdrat * paperwd ;
          %  height of image on paper (inches)
          %  using this ratio keeps all labels and titles
marginwd = (8.5 - paperwd) / 2 ;
          %  widht of left margin on paper
marginht = 9 - paperht ;
          %  widht of bottom margin on paper
          %  leaves image 2 inches down from top
set(gcf,'PaperPosition',[marginwd, marginht, paperwd, paperht]) ;
set(gcf,'PaperPositionMode','auto') ;



  orient portrait ;
print('-depsc2','SSScntr1Fig1n.eps') ;
print('-dpsc','SSScntr1Fig1n.ps') ;



