disp('MATLAB Script File:  SSS2cntr1Fig2.m') ;
%
%    Creates Figure 2 for the paper on the 
%    Contour version of Significance in Scale Space
%    and corresponding movies
%
%    This is about SSS analysis of the Earthquake data

close all ;
clear all ;

vipart = [5] ;      %  1 - movie for streamline version, Fig2a
                      %  2 - movie for dots version, Fig2b
                      %  3 - movie for dots version, alpha = 0.2, Fig2c
                      %  4 - movie for streamline version, alpha = 0.2, Fig2d
                      %  5 - figure for paper




%  Load data
%
fid = fopen('/Research/GeneralData/MtStHelens.txt','rt') ;
      %  'rt' is for "read only" and "text"
  [invec,cnt] = fscanf(fid,'%f') ; 
      %  can add a "size" parameter when don't want to read all.
      %  cnt tells how many reads were done (2 * 3 fields = 6)
fclose(fid) ;

mdata = reshape(invec',2,cnt/2)' ;
      %  since matlab does reshape down columns first 

mdata = fliplr(mdata) ;
      %  do "transpose" (i.e. swap x and y), so looks like
      %  Figure 4.2 in the Wand and Jones book.

%vgridp = [122.15,122.22,64,46.18,46.21,64] ;
      %  original vector of grid parameters
vgridp = [0.15,0.22,64,0.18,0.21,64] ;
      %  vector of grid parameters (x - 122, y - 46)
mdata(:,1) = mdata(:,1) - 122 ;
mdata(:,2) = mdata(:,2) - 46 ;


titstr = 'Earthquake Data' ;





for ipart = vipart ;


  if ipart == 1 ;    %  then do streamline analysis

    savestr = 'SSScntr1Fig2a' ;

    paramstruct = struct('imovie1',1,...
                         'vgp',vgridp,...
                         'iscreenwrite',1,...
                         'titlestr',titstr,...
                         'ishowh',1,...
                         'savestr',savestr,...
                         'stype',4) ;
 
    sss2SM(mdata,paramstruct) ;



  elseif ipart == 2 ;    %  then do curvature dot analysis

    savestr = 'SSScntr1Fig2b' ;

    paramstruct = struct('imovie1',1,...
                         'vgp',vgridp,...
                         'iscreenwrite',1,...
                         'titlestr',titstr,...
                         'ishowh',1,...
                         'savestr',savestr,...
                         'stype',2) ;
 
    sss2SM(mdata,paramstruct) ;



  elseif ipart == 3 ;    %  %  then do curvature dot analysis, alpha = 0.2

    savestr = 'SSScntr1Fig2c' ;

    paramstruct = struct('imovie1',1,...
                         'vgp',vgridp,...
                         'iscreenwrite',1,...
                         'titlestr',[titstr ', \alpha = 0.2'],...
                         'alpha',0.2,...
                         'ishowh',1,...
                         'savestr',savestr,...
                         'stype',2) ;
 
    sss2SM(mdata,paramstruct) ;



  elseif ipart == 4 ;    %  then do streamline analysis, alpha = 0.2

    savestr = 'SSScntr1Fig2d' ;

    paramstruct = struct('imovie1',1,...
                         'vgp',vgridp,...
                         'iscreenwrite',1,...
                         'titlestr',[titstr ', \alpha = 0.2'],...
                         'alpha',0.2,...
                         'ishowh',1,...
                         'savestr',savestr,...
                         'stype',4) ;
 
    sss2SM(mdata,paramstruct) ;
  
  
  

  elseif ipart == 5 ;    %  then do figure for paper
  
    h1 = 4 ;
    h2 = 5.19 ;
    
    %  Set up graphics
    %
    figure(1) ;
    clf ;
    set(gcf,'Position',[340 200 600 400]) ;



    subplot(1,2,1) ;

      paramstruct = struct('imovie',0,...
                           'hmin',h1,...
                           'nh',1,...
                           'vgp',vgridp,...
                           'iscreenwrite',1,...
                           'ishowh',0,...
                           'stype',4) ;
 
      sss2SM(mdata,paramstruct) ;

      set(gca,'XTick',[]) ;
      set(gca,'YTick',[]) ;



    subplot(1,2,2) ;

      paramstruct = struct('imovie',0,...
                           'hmin',h2,...
                           'nh',1,...
                           'vgp',vgridp,...
                           'iscreenwrite',1,...
                           'ishowh',0,...
                           'stype',2) ;
 
      sss2SM(mdata,paramstruct) ;


      %  fudge dot size
      %
      vachil = get(gca,'Children') ;
      set(vachil(1),'Marker','o') ;
      set(vachil(1),'MarkerSize',2) ;
      set(vachil(1),'LineWidth',2) ;
      set(vachil(2),'Marker','o') ;
      set(vachil(2),'MarkerSize',2) ;
      set(vachil(2),'LineWidth',2) ;
      set(vachil(3),'Marker','o') ;
      set(vachil(3),'MarkerSize',2) ;
      set(vachil(3),'LineWidth',2) ;
      set(vachil(4),'Marker','o') ;
      set(vachil(4),'MarkerSize',2) ;
      set(vachil(4),'LineWidth',2) ;

      set(gca,'XTick',[]) ;
      set(gca,'YTick',[]) ;



    %  Save graph as .eps file
    %
    vpos = get(gcf,'Position') ;
    ht2wdrat = vpos(4) / vpos(3) ;
              %  height to width ratio
    paperwd = 4.5 ;
              %  width of image on paper (inches)
    paperht = ht2wdrat * paperwd ;
              %  height of image on paper (inches)
              %  using this ratio keeps all labels and titles
    marginwd = (8.5 - paperwd) / 2 ;
              %  widht of left margin on paper
    marginht = 9 - paperht ;
              %  widht of bottom margin on paper
              %  leaves image 2 inches down from top
    set(gcf,'PaperPosition',[marginwd, marginht, paperwd, paperht]) ;
    set(gcf,'PaperPositionMode','auto') ;



      orient portrait ;
    print('-depsc2','SSScntr1Fig2.eps') ;
    print('-dpsc','SSScntr1Fig2.ps') ;





  end ;    %  of ipart if-block



end ;    %  of ipart loop
