disp('MATLAB Script File:  SSS2cntr1Fig3.m') ;
%
%    Creates Figure 3 for the paper on the 
%    Contour version of Significance in Scale Space
%    and corresponding movies
%
%    This is about SSS analysis of the simulated volcano data
%    using contours

close all ;
clear all ;

vipart = [3] ;      %  1 - movie for streamlines only, Fig3a
                      %  2 - movie for streamlines and contours, Fig3b
                      %  3 - figure for paper




%  Load data
%
ie = 4 ;
           %   4  -  volcano
in = 1 ;
           %   1  -  low noise
eval(['load \Research\sss\data\sss1d' num2str(ie) ...
                          num2str(in) ';']) ;
    % this loads the variables: xgridygrid mdat sig titstr noistr






for ipart = vipart ;


  if ipart == 1 ;    %  then do streamline only analysis

    savestr = 'SSScntr1Fig3a' ;

    paramstruct = struct('imovie1',1,...
                         'iscreenwrite',1,...
                         'titlestr',titstr,...
                         'ishowh',1,...
                         'savestr',savestr,...
                         'stype',4) ;
 
    sss2SM(mdat,paramstruct) ;



  elseif ipart == 2 ;    %  then do streamline and contour only analysis

    savestr = 'SSScntr1Fig3b' ;

    paramstruct = struct('imovie1',1,...
                         'iscreenwrite',1,...
                         'titlestr',titstr,...
                         'ishowh',1,...
                         'savestr',savestr,...
                         'stype',6) ;
 
    sss2SM(mdat,paramstruct) ;



  elseif ipart == 3 ;    %  then do figure for paper
  
  
    h1 = 8 ;
    h2 = 8 ;
    
    %  Set up graphics
    %
    figure(1) ;
    clf ;
    set(gcf,'Position',[340 200 600 400]) ;



    subplot(1,2,1) ;

      paramstruct = struct('imovie',0,...
                           'hmin',h1,...
                           'nh',1,...
                           'iscreenwrite',1,...
                           'ishowh',0,...
                           'stype',4) ;
 
      sss2SM(mdat,paramstruct) ;

      set(gca,'XTick',[]) ;
      set(gca,'YTick',[]) ;



    subplot(1,2,2) ;

      paramstruct = struct('imovie',0,...
                           'hmin',h2,...
                           'nh',1,...
                           'iscreenwrite',1,...
                           'ishowh',0,...
                           'stype',6) ;
 
      sss2SM(mdat,paramstruct) ;

      set(gca,'XTick',[]) ;
      set(gca,'YTick',[]) ;



    %  Save graph as .eps file
    %
    vpos = get(gcf,'Position') ;
    ht2wdrat = vpos(4) / vpos(3) ;
              %  height to width ratio
    paperwd = 4.5 ;
              %  width of image on paper (inches)
    paperht = ht2wdrat * paperwd ;
              %  height of image on paper (inches)
              %  using this ratio keeps all labels and titles
    marginwd = (8.5 - paperwd) / 2 ;
              %  widht of left margin on paper
    marginht = 9 - paperht ;
              %  widht of bottom margin on paper
              %  leaves image 2 inches down from top
    set(gcf,'PaperPosition',[marginwd, marginht, paperwd, paperht]) ;
    set(gcf,'PaperPositionMode','auto') ;



      orient portrait ;
    print('-depsc2','SSScntr1Fig3.eps') ;
    print('-dpsc','SSScntr1Fig3.ps') ;





  end ;    %  of ipart if-block



end ;    %  of ipart loop
