disp('MATLAB Script File:  SSS2cntr1Fig4.m') ;
%
%    Creates Figure 4 for the paper on the 
%    Contour version of Significance in Scale Space
%    and corresponding movies
%
%    This is about SSS analysis of the Melbourne Temperature data
%    using contours

close all ;
clear all ;

vipart = [3] ;      %  1 - movie for streamlines only, Fig4a
                      %  2 - movie for streamlines and contours, Fig4b
                      %  3 - figure for paper




%  Load data
%
datstr = 'Melbourne Temps' ;
xlab = 'Max Temp_t' ;
ylab = 'Max Temp_{t+1}' ;

fid = fopen('/Research/GeneralData/melbmax.dat','rt') ;
          %  'rt' is for "read only" and "text"
  [invec,cnt] = fscanf(fid,'%f') ;
          %  can add a "size" parameter when don't want to read all.
          %  cnt tells how many reads were done (2 * 3 fields = 6)
fclose(fid) ;

mdata = [invec(1:cnt-1),invec(2:cnt)] ;
          %  "y" is lag one ahead version of "x"

n = cnt - 1 ;



vgridp = [6,42,64,6,42,64] ;
          %  vector of grid parameters

titstr = 'Melbourne Temp''s' ;




for ipart = vipart ;


  if ipart == 1 ;    %  then do streamline only analysis

    savestr = 'SSScntr1Fig4a' ;

    paramstruct = struct('imovie1',1,...
                         'vgp',vgridp,...
                         'iscreenwrite',1,...
                         'titlestr',titstr,...
                         'contrsp',3,...
                         'ncontr',13,...
                         'ishowh',1,...
                         'savestr',savestr,...
                         'stype',4) ;
 
    sss2SM(mdata,paramstruct) ;



  elseif ipart == 2 ;    %  then do streamline and contour only analysis

    savestr = 'SSScntr1Fig4b' ;

    paramstruct = struct('imovie1',1,...
                         'iscreenwrite',1,...
                         'titlestr',titstr,...
                         'contrsp',3,...
                         'ncontr',13,...
                         'ishowh',1,...
                         'savestr',savestr,...
                         'stype',6) ;
 
    sss2SM(mdata,paramstruct) ;



  elseif ipart == 3 ;    %  then do figure for paper
  
    h1 = 4.36 ;
    h2 = 4.36 ;
    
    %  Set up graphics
    %
    figure(1) ;
    clf ;
    set(gcf,'Position',[340 200 600 400]) ;



    subplot(1,2,1) ;

      paramstruct = struct('imovie',0,...
                           'hmin',h1,...
                           'nh',1,...
                           'vgp',vgridp,...
                           'iscreenwrite',1,...
                           'ishowh',0,...
                           'stype',4) ;
 
      sss2SM(mdata,paramstruct) ;


      %  fudge axis labels
      %
      m = (36.4 - 8.25) / (60 - 10) ;
      b = 8.25 - m * 10 ;
      tgrid = [10 20 30] ;
      agrid = (tgrid - b) / m ;
      set(gca,'XTick',agrid) ;
      set(gca,'XTickLabel',['10'; '20'; '30']) ;
      set(gca,'YTick',agrid+5) ;
      set(gca,'YTickLabel',flipud(['10'; '20'; '30'])) ;



    subplot(1,2,2) ;

      paramstruct = struct('imovie',0,...
                           'hmin',h2,...
                           'nh',1,...
                           'vgp',vgridp,...
                           'contrsp',3,...
                           'ncontr',13,...
                           'iscreenwrite',1,...
                           'ishowh',0,...
                           'stype',6) ;
 
      sss2SM(mdata,paramstruct) ;


      %  fudge axis labels
      %
      m = (36.4 - 8.25) / (60 - 10) ;
      b = 8.25 - m * 10 ;
      tgrid = [10 20 30] ;
      agrid = (tgrid - b) / m ;
      set(gca,'XTick',agrid) ;
      set(gca,'XTickLabel',['10'; '20'; '30']) ;
      set(gca,'YTick',agrid+5) ;
      set(gca,'YTickLabel',flipud(['10'; '20'; '30'])) ;



    %  Save graph as .eps file
    %
    vpos = get(gcf,'Position') ;
    ht2wdrat = vpos(4) / vpos(3) ;
              %  height to width ratio
    paperwd = 4.5 ;
              %  width of image on paper (inches)
    paperht = ht2wdrat * paperwd ;
              %  height of image on paper (inches)
              %  using this ratio keeps all labels and titles
    marginwd = (8.5 - paperwd) / 2 ;
              %  widht of left margin on paper
    marginht = 9 - paperht ;
              %  widht of bottom margin on paper
              %  leaves image 2 inches down from top
    set(gcf,'PaperPosition',[marginwd, marginht, paperwd, paperht]) ;
    set(gcf,'PaperPositionMode','auto') ;



      orient portrait ;
    print('-depsc2','SSScntr1Fig4.eps') ;
    print('-dpsc','SSScntr1Fig4.ps') ;





  end ;    %  of ipart if-block



end ;    %  of ipart loop
