disp('MATLAB Script File:  SSS2cntr1Fig5.m') ;
%
%    Creates Figure 5 for the paper on the 
%    Contour version of Significance in Scale Space
%    and corresponding movies
%
%    This is about SSS analysis of the simulated parallel peaks data
%    testing contour types

close all ;
clear all ;

vipart = [4] ;      %  1 - movie contours, quantile spacing, Fig5a
                      %  2 - movie contours, modified quantile spacing, Fig5b
                      %  3 - movie contours, quantile spacing, Fig5c
                      %  4 - figure for paper




%  Load data
%
ie = 1 ;
           %   1  -  parallel peaks
in = 1 ;
           %   1  -  low noise
eval(['load \Research\sss\data\sss1d' num2str(ie) ...
                          num2str(in) ';']) ;
    % this loads the variables: xgridygrid mdat sig titstr noistr






for ipart = vipart ;


  if ipart == 1 ;    %  then do height spaced contours

    savestr = 'SSScntr1Fig5a' ;

    paramstruct = struct('imovie1',1,...
                         'iscreenwrite',1,...
                         'titlestr',titstr,...
                         'ishowh',1,...
                         'savestr',savestr,...
                         'stype',6) ;
 
    sss2SM(mdat,paramstruct) ;



  elseif ipart == 2 ;    %  then do modified quantile spaced contours

    savestr = 'SSScntr1Fig5b' ;

    paramstruct = struct('imovie1',1,...
                         'iscreenwrite',1,...
                         'titlestr',titstr,...
                         'ishowh',1,...
                         'savestr',savestr,...
                         'contrsp',3,...
                         'ncontr',13,...
                         'stype',6) ;
 
    sss2SM(mdat,paramstruct) ;



  elseif ipart == 3 ;    %  then do quantile spaced contours

    savestr = 'SSScntr1Fig5c' ;

    paramstruct = struct('imovie1',1,...
                         'iscreenwrite',1,...
                         'titlestr',titstr,...
                         'ishowh',1,...
                         'savestr',savestr,...
                         'contrsp',2,...
                         'ncontr',9,...
                         'stype',6) ;
 
    sss2SM(mdat,paramstruct) ;



  elseif ipart == 4 ;    %  then do figure for paper
  
    h1 = 4 ;
    h2 = 4 ;
    
    %  Set up graphics
    %
    figure(1) ;
    clf ;
    set(gcf,'Position',[340 200 600 400]) ;



    subplot(1,2,1) ;

      paramstruct = struct('imovie',0,...
                           'hmin',h1,...
                           'nh',1,...
                           'iscreenwrite',1,...
                           'ishowh',0,...
                           'stype',6) ;
 
      sss2SM(mdat,paramstruct) ;

      set(gca,'XTick',[]) ;
      set(gca,'YTick',[]) ;



    subplot(1,2,2) ;

      paramstruct = struct('imovie',0,...
                           'hmin',h2,...
                           'nh',1,...
                           'contrsp',3,...
                           'ncontr',13,...
                           'iscreenwrite',1,...
                           'ishowh',0,...
                           'stype',6) ;
 
      sss2SM(mdat,paramstruct) ;

      set(gca,'XTick',[]) ;
      set(gca,'YTick',[]) ;



    %  Save graph as .eps file
    %
    vpos = get(gcf,'Position') ;
    ht2wdrat = vpos(4) / vpos(3) ;
              %  height to width ratio
    paperwd = 4.5 ;
              %  width of image on paper (inches)
    paperht = ht2wdrat * paperwd ;
              %  height of image on paper (inches)
              %  using this ratio keeps all labels and titles
    marginwd = (8.5 - paperwd) / 2 ;
              %  widht of left margin on paper
    marginht = 9 - paperht ;
              %  widht of bottom margin on paper
              %  leaves image 2 inches down from top
    set(gcf,'PaperPosition',[marginwd, marginht, paperwd, paperht]) ;
    set(gcf,'PaperPositionMode','auto') ;



      orient portrait ;
    print('-depsc2','SSScntr1Fig5.eps') ;
    print('-dpsc','SSScntr1Fig5.ps') ;





  end ;    %  of ipart if-block



end ;    %  of ipart loop
