disp('MATLAB Script File:  SSS2cntr1Fig6n.m') ;
%
%    Creates Figure 6 for the paper on the 
%    Gray level histogram, for showing behavior of variations of the
%    Contour version of Significance in Scale Space
%    Revised version
%
%    This is about SSS analysis of the simulated volcano data
%    testing contour types

close all ;
clear all ;




%  Set up graphics
%
close all ;
figure(1) ;
clf ;
set(gcf,'Position',[240 100 450 300]) ;





%  Load data
%
ie = 1 ;
           %   1  -  parallel peaks
in = 1 ;
           %   1  -  low noise
eval(['load \Research\sss\data\sss1d' num2str(ie) ...
                          num2str(in) ';']) ;
    % this loads the variables: xgridygrid mdat sig titstr noistr

data = mdat ;



h = 4 ;



%  put lines from sss2SM.m, leading to gray level histogram
%
idatyp = 1 ;

data = data - mean(mean(data)) ;
    %  then do boundary adjustment, based on mean





%  Set additional parameters
%
m = size(data,2) ;
          %  number of cols of data matrix 
          %  (i.e. j-values in matrix coordinate system)
n = size(data,1) ;
          %  for images: number of rows of data matrix 
          %  (i.e. i-values in matrix coordinate system)
maxnm = max([n; m]) ;





%  First do smooth
%
fh = sss2fhSM(data,h,-1) ;




colormap(gray) ;
  ngray = size(gray,1) ;
  mfh = fh - min(min(fh)) ;
  mfh = mfh / max(max(mfh)) ;
  mfh = mfh * ngray ;
        %  version of fh, mapped to [0, #gray levels]
%  image([1,m],[1,n],mfh) ;

  vfh = mfh(:) ;
  gledges = 0:ngray ;
  bincts = histc(vfh,gledges) ;
  
%sum(bincts)
%length(vfh)
    %  used these lines to check

htop = 1.05 * max(bincts) ;

bar(gledges,bincts,'histc') ;
  axis([0,65,0,htop]) ;
  title('Gray Level Histogram') ;
  xlabel('Gray Level') ;
  ylabel('Counts') ;


%  draw equally spaced contours
%
ncontr = 10 ;
vhts = linspace(0,ngray,ncontr + 2) ;
vhts = vhts(2:ncontr+1) ;
hold on ;
  ph = plot([vhts; vhts],[((htop / 2) * ones(1,ncontr)) ; (htop * ones(1,ncontr))],'m-') ;
  set(ph,'Color',[0.5 0.5 0.5]) ;
hold off ;




%  draw modified quantile contours
%
ncontr = 13 ;
vprob = linspace(0,1,ncontr-2) ;
vprobleft = [0.1 * vprob(2), 0.4 * vprob(2)] ;
    %  this heavily uses "start at 0"
vprobright = [1 - 0.4 * vprob(2), 1 - 0.1 * vprob(2)] ;
    %  this heavily uses "start at 0" and "end at 1"
vprob = vprob(2:ncontr-3) ;
vprob = [vprobleft, vprob, vprobright] ;
vhts = cquantSM(vfh,vprob) ;
hold on ;
  ph = plot([vhts'; vhts'],[((htop / 2) * ones(1,ncontr)) ; zeros(1,ncontr)],'m-') ;
  set(ph,'Color',[0.5 0.5 0.5]) ;
hold off ;




%  Save graph as .eps file
%
vpos = get(gcf,'Position') ;
ht2wdrat = vpos(4) / vpos(3) ;
          %  height to width ratio
paperwd = 4.5 ;
          %  width of image on paper (inches)
paperht = ht2wdrat * paperwd ;
          %  height of image on paper (inches)
          %  using this ratio keeps all labels and titles
marginwd = (8.5 - paperwd) / 2 ;
          %  widht of left margin on paper
marginht = 9 - paperht ;
          %  widht of bottom margin on paper
          %  leaves image 2 inches down from top
set(gcf,'PaperPosition',[marginwd, marginht, paperwd, paperht]) ;
set(gcf,'PaperPositionMode','auto') ;



  orient portrait ;
print('-depsc2','SSScntr1Fig6n.eps') ;
print('-dpsc','SSScntr1Fig6n.ps') ;










