disp('MATLAB Script File:  SSS2cntr1Fig7.m') ;
%
%    Creates Figure 7 for the paper on the 
%    Contour version of Significance in Scale Space
%    and corresponding movies
%
%    This is about SSS analysis of the Earthquake data
%    using contours

close all ;
clear all ;

vipart = [4] ;      %  1 - movie for contours and streamlines, Fig7a
                      %  2 - movie for contours only, Fig7b
                      %  3 - figure for paper
                      %  4 - bw version of figure for paper




%  Load data
%
fid = fopen('/Research/GeneralData/MtStHelens.txt','rt') ;
      %  'rt' is for "read only" and "text"
  [invec,cnt] = fscanf(fid,'%f') ; 
      %  can add a "size" parameter when don't want to read all.
      %  cnt tells how many reads were done (2 * 3 fields = 6)
fclose(fid) ;

mdata = reshape(invec',2,cnt/2)' ;
      %  since matlab does reshape down columns first 

mdata = fliplr(mdata) ;
      %  do "transpose" (i.e. swap x and y), so looks like
      %  Figure 4.2 in the Wand and Jones book.

%vgridp = [122.15,122.22,64,46.18,46.21,64] ;
      %  original vector of grid parameters
vgridp = [0.15,0.22,64,0.18,0.21,64] ;
      %  vector of grid parameters (x - 122, y - 46)
mdata(:,1) = mdata(:,1) - 122 ;
mdata(:,2) = mdata(:,2) - 46 ;

titstr = 'Earthquake Data' ;






for ipart = vipart ;


  if ipart == 1 ;    %  then do contour and streamline analysis

    savestr = 'SSScntr1Fig7a' ;

    paramstruct = struct('imovie1',1,...
                         'vgp',vgridp,...
                         'iscreenwrite',1,...
                         'titlestr',titstr,...
                         'ishowh',1,...
                         'savestr',savestr,...
                         'stype',6) ;
 
    sss2SM(mdata,paramstruct) ;



  elseif ipart == 2 ;    %  then do contour only analysis

    savestr = 'SSScntr1Fig7b' ;

    paramstruct = struct('imovie1',1,...
                         'vgp',vgridp,...
                         'iscreenwrite',1,...
                         'titlestr',titstr,...
                         'ishowh',1,...
                         'savestr',savestr,...
                         'stype',5) ;
 
    sss2SM(mdata,paramstruct) ;



  elseif  ipart == 3  | ...
          ipart == 4  ;    %  then do figure for paper
  
    h = 4 ;
    
    %  Set up graphics
    %
    figure(1) ;
    clf ;
    set(gcf,'Position',[340 200 300 350]) ;


    paramstruct = struct('imovie',0,...
                         'vgp',vgridp,...
                         'hmin',h,...
                         'nh',1,...
                         'iscreenwrite',1,...
                         'ishowh',0,...
                         'stype',6) ;

    sss2SM(mdata,paramstruct) ;

      set(gca,'XTick',[]) ;
      set(gca,'YTick',[]) ;




    %  Save graph as .eps file
    %
    vpos = get(gcf,'Position') ;
    ht2wdrat = vpos(4) / vpos(3) ;
              %  height to width ratio
    paperwd = 4.5 ;
              %  width of image on paper (inches)
    paperht = ht2wdrat * paperwd ;
              %  height of image on paper (inches)
              %  using this ratio keeps all labels and titles
    marginwd = (8.5 - paperwd) / 2 ;
              %  widht of left margin on paper
    marginht = 9 - paperht ;
              %  widht of bottom margin on paper
              %  leaves image 2 inches down from top
    set(gcf,'PaperPosition',[marginwd, marginht, paperwd, paperht]) ;
    set(gcf,'PaperPositionMode','auto') ;



      orient portrait ;
    if ipart == 3 ;
      print('-depsc2','SSScntr1Fig7.eps') ;
      print('-dpsc','SSScntr1Fig7.ps') ;
    elseif ipart == 4 ;
      print('-deps','SSScntr1Fig7bw.eps') ;
      print('-dps','SSScntr1Fig7bw.ps') ;
    end ;




  end ;    %  of ipart if-block



end ;    %  of ipart loop
