disp('MATLAB Script File:  sss2fig1.m') ;
%
%   For Significance in Scale Space
%   Version 2
%   This makes FIGure 1
%   Raw data, Fred's Gamma Camera data
%






%  Set preliminary parameters
%
nxori = 256 ;
nyori = 256 ;
sub1imxs = 101 ;
sub1imxe = 240 ;
sub1imys = 51 ;
sub1imye = 170 ;
          %  indices where should cut main image

sub2imxs = 56 ;
sub2imxe = 135 ;
sub2imys = 21 ;
sub2imye = 100 ;
          %  indices (of above submiage) where should cut for 
          %       later analysis


%  read in data
%
fid = fopen('/Research/sss/data/gamcam.dat','rt') ;
          %  'rt' is for "read only" and "text"
titstr = 'Gamma Camera' ;

fstr = '%4i' ;
[mdata,cnt] = fscanf(fid,fstr,[nyori,nxori]) ;
          %  can add a "size" parameter when don't want to read all.
          %  cnt tells how many reads were done (2 * 3 fields = 6)
fclose(fid) ;

disp([' Read in ' num2str(size(mdata,1)) ' by ' ...
                             num2str(size(mdata,2)) ' data matrix']) ;


mdata = mdata' ;
          %  matrix transpose so it looks
          %  like Fred's pics




%  Extract subimage
%
mdata = mdata(sub1imys:sub1imye,sub1imxs:sub1imxe) ;



%  Plot raw data
%
figure(1) ;
  mmdata = mdata - min(min(mdata)) ;
  mmdata = mmdata / max(max(mmdata)) ;
  mmdata = mmdata * size(gray,1) ;
          %  version of mdat, mapped to [0, #gray levels]

  image(mmdata) ;
          %  scale up to the range 0 to number of gray levels
    title('') ;
    axis('image') ;
    colormap(gray) ;
    set(gca,'XTick',[]) ;
    set(gca,'YTick',[]) ;

  hold on ;
    plot([sub2imxs; sub2imxe; sub2imxe; sub2imxs; sub2imxs], ...
         [sub2imys; sub2imys; sub2imye; sub2imye; sub2imys], 'y-') ;
  hold off ;



%  Set up and print
%
orient tall ;

%  topaxespos = [.2 .6 .75 .375] ;
%  bottomaxespos = [.2 .1 .75 .375] ;
%          %  fraction of figure, at left margin
%          %  fraction of figure, at bottom margin
%          %  fraction of figure width
%          %  fraction of figure height
%  vfchil = get(gcf,'Children') ;
%  set(vfchil(1),'Position',bottomaxespos) ;
%  set(vfchil(2),'Position',topaxespos) ;
%          %  reset axes position

  ht2wdrat = size(mmdata,1) / size(mmdata,2) ;
          %  height to width ratio
  paperwd = 3.5 ;
          %  width of image on paper (inches)
  paperht = ht2wdrat * paperwd ;
          %  height of image on paper (inches)
          %  using this ratio keeps all labels and titles
  marginwd = (8.5 - paperwd) / 2 ;
          %  widht of left margin on paper
  marginht = 9 - paperht ;
          %  widht of bottom margin on paper
          %  leaves image 2 inches down from top
  set(gcf,'PaperPosition',[marginwd, marginht, paperwd, paperht]) ;

print -depsc sss2fig1.eps ;
print -dpsc sss2fig1.ps ;





vpos = get(gcf,'Position') ;
          %  coordinates of figure in screen pixels
xposlength = vpos(3) ;
yposlength = vpos(4) ;

scalefact = 1.00 ;
          %  gives good visualimpression
yposlength = scalefact * yposlength ;
xposlength = yposlength ;
          %  use square window, since these square 
          %  images fit better
set(gcf,'Position',[vpos(1) vpos(2) xposlength yposlength]) ;




%print -dbitmap ;
%          %  This copies the current graphics window in
%          %  bitmap format.  This puts graphics into 
%          %  Paint, using "paste", to be saved as .bmp file
%
%
%
%
%
%%  Extract subimage for later analysis
%%
%mdata = mdata(sub2imys:sub2imye,sub2imxs:sub2imxe) ;
%
%save \matlab\steve\sss\data\sss1fig1.mat mdata ;
%

