disp('MATLAB Script File:  sss2fig3.m') ;
%
%   For Significance in Scale Space
%   This makes FIGure 3
%   Version 2
%   SSS 12 for Fred's Gamma Camera data
%   (both for paper, and also movie for posting)


close all ;
clear all ;


ipart = 1 ;    %  1 - for figure for paper only
               %  2 - for movie for posting only
               %  3 - for both figure and movie


%  read in data
%
load \Research\sss\data\sss1fig1 ;
          %  loads image in matrix mdata




if ipart == 1  |  ipart == 3 ;     %  Do figure for paper


%  sss1(mdata,[1,2]) ;
%          %  1 -  arrows only
%          %  2 -  2 x 2 pixel blocks


  paramstruct = struct('iscreenwrite',1,...
                       'stype',1,...
                       'igrid',2,...
                       'nh',4,...
                       'imovie',0) ;

  sss2SM(mdata,paramstruct) ;


  for sp = 1:4 ;
    subplot(2,2,sp) ;

    set(gca,'XTick',[]) ;
    set(gca,'YTick',[]) ;

    set(get(gca,'Title'),'FontSize',8) ;

  end ;



  %  Set up and print
  %
  orient tall ;

    ht2wdrat = 1 ;
          %  height to width ratio
    paperwd = 5 ;
          %  width of image on paper (inches)
    paperht = ht2wdrat * paperwd ;
          %  height of image on paper (inches)
          %  using this ratio keeps all labels and titles
    marginwd = (8.5 - paperwd) / 2 ;
          %  widht of left margin on paper
    marginht = 9 - paperht ;
          %  widht of bottom margin on paper
          %  leaves image 2 inches down from top
    set(gcf,'PaperPosition',[marginwd, marginht, paperwd, paperht]) ;

  print -depsc sss2fig3.eps ;
  print -dpsc sss2fig3.ps ;



%  vpos = get(gcf,'Position') ;
%          %  coordinates of figure in screen pixels
%  xposlength = vpos(3) ;
%  yposlength = vpos(4) ;
%
%  scalefact = 1.20 ;
%          %  gives good visual impression
%  yposlength = scalefact * yposlength ;
%  xposlength = yposlength ;
%          %  use square window, since these square 
%          %  images fit better
%  if scalefact > 1 ;
%    ydown = (scalefact - 1) * vpos(4) ;
%          %  move down by this much, to keep image on screen
%  end ;
%  set(gcf,'Position',[vpos(1) vpos(2)-ydown xposlength yposlength]) ;
%
%
%
%
%  print -dbitmap ;
%          %  This copies the current graphics window in
%          %  bitmap format.  This puts graphics into 
%          %  Paint, using "paste", to be saved as .bmp file




elseif ipart == 2  |  ipart == 3 ;     %  Do movie for posting



   %  Make movie
   %
   sss1(mdata,[1,2,2]) ;
          %  1 -  arrows only
          %  2 -  2 x 2 pixel blocks
          %  2 -  movie version

   %  rename mpeg file
   %
   rnstr = ['!rename sss1.mpg sss1fig3.mpg ;'] ;
   eval(rnstr) ;



end ;


