disp('MATLAB Script File:  sss2fig4.m') ;
%
%   For Significance in Scale Space
%   This makes FIGure 4
%   Version 2
%   SSS 22 for Fred's Gamma Camera data
%   (both for paper, and also movie for posting)



ipart = 1 ;    %  1 - for figure for paper only
               %  2 - for movie for posting only
               %  3 - for both figure and movie


%  read in data
%
load \Research\sss\data\sss1fig1 ;
          %  loads image in matrix mdata




if ipart == 1  |  ipart == 3 ;     %  Do figure for paper


%  sss1(mdata,[2,2],[1,0],0.05,4) ;
%          %  2 -  dots only
%          %  2 -  2 x 2 pixel blocks
%          %  [1,0]  -  pooled noise estimate
%          %  0.05 - alpha
%          %  4 -  h

  subplot(1,2,1) ;

    paramstruct = struct('iscreenwrite',1,...
                         'stype',4,...
                         'igrid',2,...
                         'nh',1,...
                         'hmin',4,...
                         'imovie',0) ;

    sss2SM(mdata,paramstruct) ;


  set(gca,'XTick',[]) ;
  set(gca,'YTick',[]) ;

%  set(get(gca,'Title'),'FontSize',18) ;



  subplot(1,2,2) ;
  
    paramstruct = struct('iscreenwrite',1,...
                         'stype',2,...
                         'igrid',2,...
                         'nh',1,...
                         'hmin',4,...
                         'imovie',0) ;

    sss2SM(mdata,paramstruct) ;

  %  Fix up dots so they show in paper
  %
  vachil = get(gca,'Children') ;
  for ichil = 1:length(vachil) ;
    if strcmp(get(vachil(ichil),'Type'),'line') ;
      if strcmp(get(vachil(ichil),'Marker'),'.') ;
        set(vachil(ichil),'Marker','o') ;
        set(vachil(ichil),'MarkerSize',2) ;
        set(vachil(ichil),'LineWidth',2) ;
      end ;
    end ;
  end ;

  set(gca,'XTick',[]) ;
  set(gca,'YTick',[]) ;





  %  Set up and print
  %
  orient tall ;

    ht2wdrat = 1 ;
          %  height to width ratio
    paperwd = 5 ;
          %  width of image on paper (inches)
    paperht = ht2wdrat * paperwd ;
          %  height of image on paper (inches)
          %  using this ratio keeps all labels and titles
    marginwd = (8.5 - paperwd) / 2 ;
          %  widht of left margin on paper
    marginht = 9 - paperht ;
          %  widht of bottom margin on paper
          %  leaves image 2 inches down from top
    set(gcf,'PaperPosition',[marginwd, marginht, paperwd, paperht]) ;

  print -depsc sss2fig4.eps ;
  print -dpsc sss2fig4.ps ;




  %  Change dots to symbols that work better in Sci Word
  %
%  vachil = get(gca,'Children') ;
%  for ic = 1:length(vachil) ;

%    if get(vachil(ic),'Type') == 'line' ;
%      set(vahcil(ic),'Marker','o') ;
%      set(vahcil(ic),'MarkerSize',4) ;
%       xdata = get(vachil(ic),'XData') ;
%       ydata = get(vachil(ic),'YData') ;

%    end ;


%  end ;



%
%  print -dmeta ;
%          %  This copies the current graphics window in
%          %  metafile format.  To get into Sci Word, just
%          %  use "paste" (or graphics clipboard button)
%          %  Then rescale, using "custom"  (arrows are best)
%          %  (50% worked well for this one)
%


elseif ipart == 2  |  ipart == 3 ;     %  Do movie for posting


   %  Make movie
   %
  sss1(mdata,[2,2,2]) ;
          %  2 -  dots only
          %  2 -  2 x 2 pixel blocks
          %  2 -  movie version


   %  rename mpeg file
   %
   rnstr = ['!rename sss1.mpg sss1fig4.mpg ;'] ;
   eval(rnstr) ;



end ;


