disp('MATLAB Script File:  sss2fig5.m') ;
%
%   For Significance in Scale Space
%   This makes FIGure 5
%   Version 2
%   Boundary stuff for Tommerdahl's Subimage 3

clear all ;
close all ;


ipart = 1 ;    %  1 - for figure for paper only
               %  2 - for movie for posting only
               %  3 - for both figure and movie


%  Load subimage data
%
load \Research\sss\data\tomm14sub ;
    %  Loads:
    %    subim1 subim2 subim3,   80 x 80 image files
    %    subim1xs, etc.    x starting pixel numbers
    %    subim1xe, etc.    x ending pixel numbers
    %    subim1ys, etc.    y starting pixel numbers
    %    subim1ye, etc.    y ending pixel numbers
    %    subimstr       descriptive string



mdata = subim1 ;
          %  work with subimage number 1



%  set common parameters
%
colormap(gray) ;
h = 4 ;




if ipart == 1  |  ipart == 3 ;     %  Do figure for paper


  subplot(2,2,1) ;    %  Plot raw data
    bottom = min(min(mdata)) ;
    plotdata = mdata - bottom ;
    scalefact = 1 / max(max(plotdata)) ;
    plotdata = plotdata * scalefact ;
    plotdata = plotdata * size(gray,1) ;
          %  version of fh, mapped to [0, #gray levels]
    image(plotdata) ;
      title(['Raw Data']) ;
      axis('image') ;
    set(gca,'XTick',[]) ;
    set(gca,'YTick',[]) ;
    



  subplot(2,2,2) ;    %  Plot unadjusted smooth, h = 4 ;
    n = size(mdata,1) ;
          %  number of rows of data matrix (i.e. y-values)
    m = size(mdata,2) ;
          %  number of cols of data matrix (i.e. x-values)

    mker = k2dgSM(((1-n):(n-1))',(1-m):(m-1),h) ;

    fh = conv2(mker,mdata,'valid') ;
          %  f_h (hat)

    mfh = fh - min(min(fh)) ;
    mfh = mfh / max(max(mfh)) ;
    mfh = mfh * size(gray,1) ;
          %  version of fh, mapped to [0, #gray levels]
    image(mfh) ;      
      axis('square') ;
      title(['Unadjusted, h = ' num2str(h)]) ;
      set(gca,'XTick',[]) ;
      set(gca,'YTick',[]) ;




  subplot(2,2,3) ;    %  Plot adjusted smooth, h = 4 ;
    n = size(mdata,1) ;
          %  number of rows of data matrix (i.e. y-values)
    m = size(mdata,2) ;
          %  number of cols of data matrix (i.e. x-values)

    meanmdata = mean(mean(mdata)) ;
    mmdata = mdata - meanmdata ;

    mker = k2dgSM(((1-n):(n-1))',(1-m):(m-1),h) ;

    fh = conv2(mker,mmdata,'valid') ;
          %  f_h (hat)

    mfh = fh + meanmdata - bottom ;
    mfh = mfh * scalefact ;
    mfh = mfh * size(gray,1) ;
          %  version of fh, mapped to [0, #gray levels]
    image(mfh) ;      
      axis('square') ;
      title(['Unscaled, h = ' num2str(h)]) ;
      set(gca,'XTick',[]) ;
      set(gca,'YTick',[]) ;



  subplot(2,2,4) ;    %  Plot adjusted smooth, h = 4 ;
    n = size(mdata,1) ;
          %  number of rows of data matrix (i.e. y-values)
    m = size(mdata,2) ;
          %  number of cols of data matrix (i.e. x-values)

    meanmdata = mean(mean(mdata)) ;
    mmdata = mdata - meanmdata ;

    mker = k2dgSM(((1-n):(n-1))',(1-m):(m-1),h) ;

    fh = conv2(mker,mmdata,'valid') ;
          %  f_h (hat)

    mfh = fh - min(min(fh)) ;
    mfh = mfh / max(max(mfh)) ;
    mfh = mfh * size(gray,1) ;
          %  version of fh, mapped to [0, #gray levels]
    image(mfh) ;      
      axis('square') ;
      title(['Adjusted, h = ' num2str(h)]) ;
      set(gca,'XTick',[]) ;
      set(gca,'YTick',[]) ;
 



  %  Set up and print
  %
  orient tall ;

    ht2wdrat = 1 ;
          %  height to width ratio
    paperwd = 5 ;
          %  width of image on paper (inches)
    paperht = ht2wdrat * paperwd ;
          %  height of image on paper (inches)
          %  using this ratio keeps all labels and titles
    marginwd = (8.5 - paperwd) / 2 ;
          %  widht of left margin on paper
    marginht = 9 - paperht ;
          %  widht of bottom margin on paper
          %  leaves image 2 inches down from top
    set(gcf,'PaperPosition',[marginwd, marginht, paperwd, paperht]) ;

  print -depsc sss2fig5.eps ;
  print -dpsc sss2fig5.ps ;





%  vpos = get(gcf,'Position') ;
%          %  coordinates of figure in screen pixels
%  xposlength = vpos(3) ;
%  yposlength = vpos(4) ;
%
%  scalefact = 1.20 ;
%          %  gives good visual impression
%  yposlength = scalefact * yposlength ;
%  xposlength = yposlength ;
%          %  use square window, since these square 
%          %  images fit better
%  if scalefact > 1 ;
%    ydown = (scalefact - 1) * vpos(4) ;
%          %  move down by this much, to keep image on screen
%  end ;
%  set(gcf,'Position',[vpos(1) vpos(2)-ydown xposlength yposlength]) ;
%
%
%
%
%  print -dbitmap ;
%          %  This copies the current graphics window in
%          %  bitmap format.  This puts graphics into 
%          %  Paint, using "paste", to be saved as .bmp file
%




elseif ipart == 2  |  ipart == 3 ;     %  Do movie for posting



   %  Make No Adjustment movie
   %
   sss1(mdata,[0,0,2],[1,0],0.05,0,0,0) ;
          %  [0,0,2]  -  smooths only, movie
          %  [1,0]  -  variance parameter
          %  0.05  -  alpha
          %  0  -  use default bandwidth range
          %  0  -  vgp
          %  0  -  no boundary adjustment

   %  rename mpeg file
   %
   rnstr = ['!rename sss1.mpg sss1fig5a.mpg ;'] ;
   eval(rnstr) ;




   %  Make Adjustment movie
   %
   sss1(mdata,[0,0,2]) ;
          %  [0,0,2]  -  smooths only, movie

   %  rename mpeg file
   %
   rnstr = ['!rename sss1.mpg sss1fig5b.mpg ;'] ;
   eval(rnstr) ;



end ;


