disp('MATLAB Script File:  sss2fig6.m') ;
%
%   For Significance in Scale Space
%   This makes FIGure 6
%   Version 2
%   SSS 32 and 4 for Fred's Gamma Camera data
%   (both for paper, and also movie for posting)



ipart = 1 ;    %  1 - for figure for paper only
               %  2 - for movie for posting only
               %  3 - for both figure and movie


%  read in data
%
load \Research\sss\data\sss1fig1 ;
          %  loads image in matrix mdata




if ipart == 1  |  ipart == 3 ;     %  Do figure for paper


  figure(1) ;
  clf ;



%  %  Set figure size for convenient copying and pasting
%  %
%  vpos = get(gcf,'Position') ;
%          %  coordinates of figure in screen pixels
%  xposlength = vpos(3) ;
%  yposlength = vpos(4) ;
%
%  scalefact = 0.50 ;
%          %  gives good visula impression
%  yposlength = scalefact * yposlength ;
%  xposlength = yposlength ;
%          %  use square window, since these square 
%          %  images fit better
%  set(gcf,'Position',[vpos(1) vpos(2) xposlength yposlength]) ;

  set(gcf,'Position',[340 200 600 400]) ;



%  sss1(mdata,[3,2],[1,0],0.05,4) ;
%          %  3 -  dots and arrows
%          %  2 -  2 x 2 pixel blocks
%          %  [1,0]  -  pooled noise estimate
%          %  0.05 - alpha
%          %  4 -  h
%    
  
  paramstruct = struct('iscreenwrite',1,...
                       'stype',3,...
                       'igrid',2,...
                       'nh',1,...
                       'hmin',4,...
                       'imovie',0) ;

  sss2SM(mdata,paramstruct) ;

  %  Fix up dots so they show in paper
  %
  vachil = get(gca,'Children') ;
  for ichil = 1:length(vachil) ;
    if strcmp(get(vachil(ichil),'Type'),'line') ;
      if strcmp(get(vachil(ichil),'Marker'),'.') ;
        set(vachil(ichil),'Marker','o') ;
        set(vachil(ichil),'MarkerSize',2) ;
        set(vachil(ichil),'LineWidth',2) ;
      end ;
    end ;
  end ;

  set(gca,'XTick',[]) ;
  set(gca,'YTick',[]) ;

%  set(get(gca,'Title'),'FontSize',18) ;




  %  Change dots to symbols that work better in Sci Word
  %
%  vachil = get(gca,'Children') ;
%  for ic = 1:length(vachil) ;

%    if get(vachil(ic),'Type') == 'line' ;
%      set(vahcil(ic),'Marker','o') ;
%      set(vahcil(ic),'MarkerSize',4) ;
%       xdata = get(vachil(ic),'XData') ;
%       ydata = get(vachil(ic),'YData') ;

%    end ;


%  end ;



%
%
%  print -dmeta ;
%          %  This copies the current graphics window in
%          %  metafile format.  This puts graphics into 
%          %  Sci Word, via: create display, the "paste".
%
%
%
%
%  disp('Paste this into Sci Word, then') ;
%  gppause
%


%  sss1(mdata,4,[1,0],0.05,4) ;
%          %  4 -  streamlines
%          %  [1,0]  -  pooled noise estimate
%          %  0.05 - alpha
%          %  4 -  h



  %  Set up and print
  %
  orient tall ;

    ht2wdrat = 1 ;
          %  height to width ratio
    paperwd = 5 ;
          %  width of image on paper (inches)
    paperht = ht2wdrat * paperwd ;
          %  height of image on paper (inches)
          %  using this ratio keeps all labels and titles
    marginwd = (8.5 - paperwd) / 2 ;
          %  widht of left margin on paper
    marginht = 9 - paperht ;
          %  widht of bottom margin on paper
          %  leaves image 2 inches down from top
    set(gcf,'PaperPosition',[marginwd, marginht, paperwd, paperht]) ;

  print -depsc sss2fig6.eps ;
  print -dpsc sss2fig6.ps ;






%
%  print -dmeta ;
%          %  This copies the current graphics window in
%          %  metafile format.  This time, paste into
%          %  Sci Word, by putting cursor next to Figure 6a,
%          %  and doing "paste".
%          %
%          %  Note:  to rename files in Sci Word (pasting
%          %  gives a random name), select graphic, and
%          %  then type in new filename (including directory)
%
%



elseif ipart == 2  |  ipart == 3 ;     %  Do movie for posting


  close all ;
  figure(1) ;
  clf ;



  %  Make movie
  %
  sss1(mdata,[3,2,2]) ;
          %  3 -  dots and arrows
          %  2 -  2 x 2 pixel blocks
          %  2 -  movie version


   %  rename mpeg file
   %
   rnstr = ['!rename sss1.mpg sss1fig6a.mpg ;'] ;
   eval(rnstr) ;





  %  Make movie
  %
  sss1(mdata,[4,0,2]) ;
          %  4 -  streamlines
          %  2 -  movie version


   %  rename mpeg file
   %
   rnstr = ['!rename sss1.mpg sss1fig6b.mpg ;'] ;
   eval(rnstr) ;


end ;


