disp('MATLAB Script File:  sss2fig7.m') ;
%
%   For Significance in Scale Space
%   This makes FIGure 7
%   Version 2
%   SSS 32 for different alphas, peaks and Valleys
%   (both for paper, and also movies for posting)



ipart = 1 ;    %  1 - for figure for paper only
               %  2 - for movie for posting only
               %  3 - for both figure and movie


%  read in data
%
ieg = 2 ;    % 
               %   1  -  parallel peaks
               %   2  -  peaks and valleys
               %   3  -  sombrero
               %   4  -  volcano
               %   5  -  piecewise linear

inoise = 2 ;    % 
                  %  1  -  low noise
                  %  2  -  medium noise
                  %  3  -  high noise

eval(['load \Research\sss\data\sss1d' num2str(ieg) ...
                                num2str(inoise) ';']) ;
          % this loads the variables: xgrid ygrid mdat sig titstr noistr




h = 4 ;





if ipart == 1  |  ipart == 3 ;     %  Do figure for paper


  close all ;
  figure(1) ;
  clf ;



  %  Set figure size for convenient copying and pasting
  %
%  vpos = get(gcf,'Position') ;
%          %  coordinates of figure in screen pixels
%  xposlength = vpos(3) ;
%  yposlength = vpos(4) ;
%
%  scalefact = 0.50 ;
%          %  gives good visula impression
%  yposlength = scalefact * yposlength ;
%  xposlength = yposlength ;
%          %  use square window, since these square 
%          %  images fit better
%  set(gcf,'Position',[vpos(1) vpos(2) xposlength yposlength]) ;

  set(gcf,'Position',[340 200 600 400]) ;




%  alpha = 0.01 ;
%  sss1(mdat,[3,2],[1,0],alpha,h) ;
%          %  3 -  dots and arrows
%          %  2 -  2 x 2 pixel blocks
%          %  [1,0]  -  pooled noise estimate
%    title(['\alpha = ' num2str(alpha)]) ;

  subplot(1,2,1) ;
  
    paramstruct = struct('iscreenwrite',1,...
                         'stype',3,...
                         'alpha',0.01,...
                         'titlestr','\alpha = 0.01',...
                         'igrid',2,...
                         'nh',1,...
                         'hmin',h,...
                         'imovie',0) ;

    sss2SM(mdat,paramstruct) ;

    %  Fix up dots so they show in paper
    %
    vachil = get(gca,'Children') ;
    for ichil = 1:length(vachil) ;
      if strcmp(get(vachil(ichil),'Type'),'line') ;
        if strcmp(get(vachil(ichil),'Marker'),'.') ;
          set(vachil(ichil),'Marker','o') ;
          set(vachil(ichil),'MarkerSize',2) ;
          set(vachil(ichil),'LineWidth',2) ;
        end ;
      end ;
    end ;


    set(gca,'XTick',[]) ;
    set(gca,'YTick',[]) ;






%  print -dmeta ;
%          %  This copies the current graphics window in
%          %  metafile format.  This puts graphics into 
%          %  Sci Word, via: create display, the "paste".
%
%
%
%
%  disp('Paste this into Sci Word, then') ;
%  gppause





%  alpha = 0.2 ;
%  sss1(mdat,[3,2],[1,0],alpha,h) ;
%          %  3 -  dots and arrows
%          %  2 -  2 x 2 pixel blocks
%          %  [1,0]  -  pooled noise estimate
%    title(['\alpha = ' num2str(alpha)]) ;

  subplot(1,2,2) ;
  
    paramstruct = struct('iscreenwrite',1,...
                         'stype',3,...
                         'alpha',0.2,...
                         'titlestr','\alpha = 0.2',...
                         'igrid',2,...
                         'nh',1,...
                         'hmin',h,...
                         'imovie',0) ;

    sss2SM(mdat,paramstruct) ;

    %  Fix up dots so they show in paper
    %
    vachil = get(gca,'Children') ;
    for ichil = 1:length(vachil) ;
      if strcmp(get(vachil(ichil),'Type'),'line') ;
        if strcmp(get(vachil(ichil),'Marker'),'.') ;
          set(vachil(ichil),'Marker','o') ;
          set(vachil(ichil),'MarkerSize',2) ;
          set(vachil(ichil),'LineWidth',2) ;
        end ;
      end ;
    end ;

    set(gca,'XTick',[]) ;
    set(gca,'YTick',[]) ;



  %  Set up and print
  %
  orient tall ;

    ht2wdrat = 1 ;
          %  height to width ratio
    paperwd = 5 ;
          %  width of image on paper (inches)
    paperht = ht2wdrat * paperwd ;
          %  height of image on paper (inches)
          %  using this ratio keeps all labels and titles
    marginwd = (8.5 - paperwd) / 2 ;
          %  widht of left margin on paper
    marginht = 9 - paperht ;
          %  widht of bottom margin on paper
          %  leaves image 2 inches down from top
    set(gcf,'PaperPosition',[marginwd, marginht, paperwd, paperht]) ;

  print -depsc sss2fig7.eps ;
  print -dpsc sss2fig7.ps ;



%  print -dmeta ;
%          %  This copies the current graphics window in
%          %  metafile format.  This time, paste into
%          %  Sci Word, by putting cursor next to Figure 7a,
%          %  and doing "paste".
%          %
%          %  Note:  to rename files in Sci Word (pasting
%          %  gives a random name), select graphic, and
%          %  then type in new filename (including directory)





elseif ipart == 2  |  ipart == 3 ;     %  Do movie for posting


  close all ;
  figure(1) ;
  clf ;



  %  Make movie for fig 7a
  %
  alpha = 0.01 ;
  sss1(mdat,[3,2,2],[1,0],alpha) ;
          %  3 -  dots and arrows
          %  2 -  2 x 2 pixel blocks
          %  2 -  movie version
          %  [1,0]  -  pooled noise estimate


  %  rename mpeg file
  %
  rnstr = ['!rename sss1.mpg sss1fig7a.mpg ;'] ;
  eval(rnstr) ;




  %  Make movie for fig 7b
  %
  alpha = 0.2 ;
  sss1(mdat,[3,2,2],[1,0],alpha) ;
          %  3 -  dots and arrows
          %  2 -  2 x 2 pixel blocks
          %  2 -  movie version
          %  [1,0]  -  pooled noise estimate


  %  rename mpeg file
  %
  rnstr = ['!rename sss1.mpg sss1fig7b.mpg ;'] ;
  eval(rnstr) ;





end ;


