disp('MATLAB Script File:  sss2fig10.m') ;
%
%   For Significance in Scale Space
%   This makes FIGure 10
%   Version 2
%   Streamlines for Tommerdahl's data



ipart = 1 ;     %  1 - to make plots for the paper
                %  2 - to make graphics for talk
                %  3 - to make movies for posting



%  read in data
%
%  Load subimage data
%
load \Research\sss\data\tomm14sub ;
    %  Loads:
    %    subim1 subim2 subim3,   80 x 80 image files
    %    subim1xs, etc.    x starting pixel numbers
    %    subim1xe, etc.    x ending pixel numbers
    %    subim1ys, etc.    y starting pixel numbers
    %    subim1ye, etc.    y ending pixel numbers
    %    subimstr       descriptive string




if ipart == 1 ;

  h = 5 ;


  close all ;
  figure(1) ;
  clf ;



  %  Set figure size for convenient copying and pasting
  %
%  vpos = get(gcf,'Position') ;
%          %  coordinates of figure in screen pixels
%  xposlength = vpos(3) ;
%  yposlength = vpos(4) ;
%
%  scalefact = 0.50 ;
%          %  gives good visual impression
%  yposlength = scalefact * yposlength ;
%  xposlength = yposlength ;
%          %  use square window, since these square 
%          %  images fit better
%  set(gcf,'Position',[vpos(1) vpos(2) xposlength yposlength]) ;

  set(gcf,'Position',[340 200 600 400]) ;



  mdata = subim1 ;
          %  work with subimage number 1


%  sss1(mdata,4,[1,0],0.05,h) ;
%          %  4 -  streamlines
%          %  [1,0]  -  pooled noise estimate
%          %  0.05 - alpha

  subplot(1,2,1) ;

    paramstruct = struct('iscreenwrite',1,...
                         'stype',4,...
                         'nh',1,...
                         'hmin',h,...
                         'imovie',0) ;

    sss2SM(mdata,paramstruct) ;

    set(gca,'XTick',[]) ;
    set(gca,'YTick',[]) ;




%  print -dmeta ;
%          %  This copies the current graphics window in
%          %  metafile format.  This puts graphics into 
%          %  Sci Word, via: create display, the "paste".
%
%
%
%
%  disp('Paste this into Sci Word, then') ;
%  gppause






  mdata = subim3 ;
          %  work with subimage number 3


%  sss1(mdata,4,[1,0],0.05,h) ;
%          %  4 -  streamlines
%          %  [1,0]  -  pooled noise estimate
%          %  0.05 - alpha

  subplot(1,2,2) ;

    paramstruct = struct('iscreenwrite',1,...
                         'stype',4,...
                         'nh',1,...
                         'hmin',h,...
                         'imovie',0) ;

    sss2SM(mdata,paramstruct) ;

    set(gca,'XTick',[]) ;
    set(gca,'YTick',[]) ;


%  print -dmeta ;
%          %  This copies the current graphics window in
%          %  metafile format.  This time, paste into
%          %  Sci Word, by putting cursor next to Figure 10a,
%          %  and doing "paste".
%          %
%          %  Note:  to rename files in Sci Word (pasting
%          %  gives a random name), select graphic, and
%          %  then type in new filename (including directory)


  %  Set up and print
  %
  orient tall ;

    ht2wdrat = 1 ;
          %  height to width ratio
    paperwd = 5 ;
          %  width of image on paper (inches)
    paperht = ht2wdrat * paperwd ;
          %  height of image on paper (inches)
          %  using this ratio keeps all labels and titles
    marginwd = (8.5 - paperwd) / 2 ;
          %  widht of left margin on paper
    marginht = 9 - paperht ;
          %  widht of bottom margin on paper
          %  leaves image 2 inches down from top
    set(gcf,'PaperPosition',[marginwd, marginht, paperwd, paperht]) ;

  print -depsc sss2fig10.eps ;
  print -dpsc sss2fig10.ps ;




elseif ipart == 2 ;

  h = 5 ;


  close all ;
  figure(1) ;
  clf ;



  mdata = subim1 ;
          %  work with subimage number 1



  bottom = min(min(mdata)) ;
  plotdata = mdata - bottom ;
  scalefact = 1 / max(max(plotdata)) ;
  plotdata = plotdata * scalefact ;
  plotdata = plotdata * size(gray,1) ;
          %  version of fh, mapped to [0, #gray levels]
  image(plotdata) ;
    colormap(gray)
    axis('image') ;
  set(gca,'XTick',[]) ;
  set(gca,'YTick',[]) ;
    




  vpos = get(gcf,'Position') ;
          %  coordinates of figure in screen pixels
  xposlength = vpos(3) ;
  yposlength = vpos(4) ;

  scalefact = 0.60 ;
          %  gives good visual impression
  yposlength = scalefact * yposlength ;
  xposlength = yposlength ;
          %  use square window, since these square 
          %  images fit better
  if scalefact > 1 ;
    ydown = (scalefact - 1) * vpos(4) ;
          %  move down by this much, to keep image on screen
  end ;
  set(gcf,'Position',[vpos(1) vpos(2)-ydown xposlength yposlength]) ;




  print -dbitmap ;
          %  This copies the current graphics window in
          %  bitmap format.  This puts graphics into 
          %  Paint, using "paste", to be saved as .bmp file


  disp('Paste this into Paint, then') ;
  gppause ;







  sss1(mdata,4,[1,0],0.05,h) ;
          %  4 -  streamlines
          %  [1,0]  -  pooled noise estimate
          %  0.05 - alpha
    set(gca,'XTick',[]) ;
    set(gca,'YTick',[]) ;




  print -dmeta ;
          %  This copies the current graphics window in
          %  metafile format.  This puts graphics into 
          %  Sci Word, via: create display, the "paste".


  disp('Paste this into Paint, then') ;
  gppause ;








  mdata = subim3 ;
          %  work with subimage number 3



  bottom = min(min(mdata)) ;
  plotdata = mdata - bottom ;
  scalefact = 1 / max(max(plotdata)) ;
  plotdata = plotdata * scalefact ;
  plotdata = plotdata * size(gray,1) ;
          %  version of fh, mapped to [0, #gray levels]
  image(plotdata) ;
    axis('image') ;
  set(gca,'XTick',[]) ;
  set(gca,'YTick',[]) ;




  print -dbitmap ;
          %  This copies the current graphics window in
          %  bitmap format.  This puts graphics into 
          %  Paint, using "paste", to be saved as .bmp file


  disp('Paste this into Paint, then') ;
  gppause ;





  sss1(mdata,4,[1,0],0.05,h) ;
          %  4 -  streamlines
          %  [1,0]  -  pooled noise estimate
          %  0.05 - alpha
    set(gca,'XTick',[]) ;
    set(gca,'YTick',[]) ;


  print -dmeta ;
          %  This copies the current graphics window in
          %  metafile format.  This time, paste into
          %  Sci Word, by putting cursor next to Figure 10a,
          %  and doing "paste".
          %
          %  Note:  to rename files in Sci Word (pasting
          %  gives a random name), select graphic, and
          %  then type in new filename (including directory)






elseif ipart == 3 ;

  close all ;
  figure(1) ;
  clf ;



  mdata = subim1 ;
          %  work with subimage number 1


  sss1(mdata,[4,0,2],[1,0]) ;
          %  4 -  streamlines
          %  2 -  movie version
          %  [1,0]  -  pooled noise estimate


  %  rename mpeg file
  %
  rnstr = ['!rename sss1.mpg sss1fig10a.mpg ;'] ;
  eval(rnstr) ;




  mdata = subim3 ;
          %  work with subimage number 3


  sss1(mdata,[4,0,2],[1,0]) ;
          %  4 -  streamlines
          %  2 -  movie version
          %  [1,0]  -  pooled noise estimate


  %  rename mpeg file
  %
  rnstr = ['!rename sss1.mpg sss1fig10b.mpg ;'] ;
  eval(rnstr) ;



end ;


