disp('MATLAB Script File:  sss2fig12.m') ;
%
%   For Significance in Scale Space
%   This makes FIGure 12
%   Version 2
%   Streamlines for Haavard's Confocal data
%   (from his web page http://www.math.ntnu.no/~hrue/files/confocal)

%   (both for paper, and also movies for posting)



ipart = 1 ;    %  1 - for figure for paper only
               %  2 - for movie for posting only
               %  3 - for both figure and movie





%  Set preliminary parameters
%
nxori = 384 ;
nyori = 92 ;
subimxs = 21 ;
subimxe = 100 ;
subimys = 11 ;
subimye = 90 ;




%  read in data
%
%fid = fopen('/Research/sss/data/tomoxAcf.txt','rt') ;
          %  decided this was probably from the middle of an
          %  MCMC run, so should go to beginning
fid = fopen('/Research/sss/data/tomoxAaa.txt','rt') ;
          %  'r' is for "read only" 
titstr = 'Confocal' ;

fstr = '%4i' ;
%[mdata,cnt] = fscanf(fid,fstr,[nyori,nxori]) ;
[mdata,cnt] = fscanf(fid,fstr,[nxori,nyori]) ;
          %  can add a "size" parameter when don't want to read all.
          %  cnt tells how many reads were done (2 * 3 fields = 6)
fclose(fid) ;


disp([' Read in ' num2str(size(mdata,1)) ' by ' ...
                             num2str(size(mdata,2)) ' data matrix']) ;


mdata = mdata' ;
          %  matrix transpose so it looks
          %  like Haavard's pics



%  Extract subimage
%
mdata = mdata(subimys:subimye,subimxs:subimxe) ;






h = 3 ;





if ipart == 1  |  ipart == 3 ;     %  Do figure for paper


  close all ;
  figure(1) ;
  clf ;



%  %  Set figure size for convenient copying and pasting
%  %
%  vpos = get(gcf,'Position') ;
%          %  coordinates of figure in screen pixels
%  xposlength = vpos(3) ;
%  yposlength = vpos(4) ;
%
%  scalefact = 0.50 ;
%          %  gives good visula impression
%  yposlength = scalefact * yposlength ;
%  xposlength = yposlength ;
%          %  use square window, since these square 
%          %  images fit better
%  set(gcf,'Position',[vpos(1) vpos(2) xposlength yposlength]) ;

  set(gcf,'Position',[340 200 600 400]) ;



  mmdata = mdata - min(min(mdata)) ;
  mmdata = mmdata / max(max(mmdata)) ;
  mmdata = mmdata * size(gray,1) ;
          %  version of mdat, mapped to [0, #gray levels]

  subplot(1,2,1) ;

  image(mmdata) ;
    axis('square') ;
    colormap(gray) ;

    set(gca,'XTick',[]) ;
    set(gca,'YTick',[]) ;






%  print -dmeta ;
%          %  This copies the current graphics window in
%          %  metafile format.  This puts graphics into 
%          %  Sci Word, via: create display, the "paste".
%
%
%
%
%  disp('Paste this into Sci Word, then') ;
%  gppause





  alpha = 0.05 ;
%  sss1(mdata,4,[1,0],alpha,h) ;
%          %  4 -  streamlines
%          %  [1,0]  -  pooled noise estimate

  subplot(1,2,2) ;

    paramstruct = struct('iscreenwrite',1,...
                         'stype',4,...
                         'nh',1,...
                         'hmin',h,...
                         'imovie',0) ;

    sss2SM(mmdata,paramstruct) ;

    set(gca,'XTick',[]) ;
    set(gca,'YTick',[]) ;



%  print -dmeta ;
%          %  This copies the current graphics window in
%          %  metafile format.  This time, paste into
%          %  Sci Word, by putting cursor next to Figure 12a,
%          %  and doing "paste".
%          %
%          %  Note:  to rename files in Sci Word (pasting
%          %  gives a random name), select graphic, and
%          %  then type in new filename (including directory)



  %  Set up and print
  %
  orient tall ;

    ht2wdrat = 1 ;
          %  height to width ratio
    paperwd = 5 ;
          %  width of image on paper (inches)
    paperht = ht2wdrat * paperwd ;
          %  height of image on paper (inches)
          %  using this ratio keeps all labels and titles
    marginwd = (8.5 - paperwd) / 2 ;
          %  widht of left margin on paper
    marginht = 9 - paperht ;
          %  widht of bottom margin on paper
          %  leaves image 2 inches down from top
    set(gcf,'PaperPosition',[marginwd, marginht, paperwd, paperht]) ;

  print -depsc sss2fig12.eps ;
  print -dpsc sss2fig12.ps ;






elseif ipart == 2  |  ipart == 3 ;     %  Do movie for posting


  close all ;
  figure(1) ;
  clf ;




  %  Make movie for fig 12b
  %
  sss1(mdata,[4,0,2],[1,0]) ;
          %  4 -  streamlines
          %  2 -  movie version
          %  [1,0]  -  pooled noise estimate




  %  rename mpeg file
  %
  rnstr = ['!rename sss1.mpg sss1fig12b.mpg ;'] ;
  eval(rnstr) ;




  %  Make movie for fig 12c
  %
  sss1(mdata,[3,2,2],[1,0]) ;
          %  3 -  dots and arrows
          %  2 -  2x2 pixel blocks
          %  2 -  movie version
          %  [1,0]  -  pooled noise estimate


  %  rename mpeg file
  %
  rnstr = ['!rename sss1.mpg sss1fig12c.mpg ;'] ;
  eval(rnstr) ;





end ;


