disp('Running MATLAB script file SZHazCenFig1.m') ;
%
%    Creates Figure 1 for the paper on
%    Censored, Hazard SiZer paper
%
%    Copied from CHSZeg1.m,
%    Censored Hazard SiZer, Example 1. 
%    (this is ipart = 2)



%  Old data generation lines
%
  n = 500 ;
  left = -2.5 ;
  right = 2 ;
  rand('seed',43570293) ;
  randn('seed',19237419) ;


  %  Generate data
  %
  vt = randn(n,1) / 2 ;
          %  column vector of i.i.d. Gaussian(0,1/4)s
  vt = vt + 1 * (1 - 2 * (rand(n,1) > .5)) ;
          %  add random +- 1

  vc = randn(n,1) / 2 ;
          %  column vector of i.i.d. Gaussian(0,1/4)s
  vc = vc + 1 * (1 - 2 * (rand(n,1) > .5)) ;
          %  add random +- 1

  vdata = min(vt,vc) ;
  vdel = vdata == vt ;

  vucdata = vdata(vdel) ;
  nuc = length(vucdata) ;
  vcdata = vdata(~vdel) ;


  figure(1) ;
  clf ;


  subplot(2,2,1) ;    %  upper left, uncensored family
    foltit = ['n = ' num2str(nuc+1) ...
              ' only uncensored data'] ;
    paramstruct = struct('iout',4,...
                         'famoltitle',foltit,...
                         'titlefontsize',18,...
                         'imovie',0,...
                         'minx',left,...
                         'maxx',right,...
                         'ihhighlight',0,...
                         'ndataoverlay',0,...
                         'iscreenwrite',1) ;
  sizer2(vucdata,paramstruct) ;
  hold on ;    %  add jitter plot
    vax = axis ;
    vjit1 = rand(nuc,1) ;
    randht = vax(3) + (0.6 + 0.3 * vjit1) * ...
                              (vax(4) - vax(3)) ;
    plot(vucdata,randht,'g.') ;
  hold off ;


  subplot(2,2,3) ;    %  upper left, uncensored SiZer
    paramstruct = struct('iout',6,...
                         'sizertitle','Uncensored SiZer Map',...
                         'titlefontsize',18,...
                         'imovie',0,...
                         'minx',left,...
                         'maxx',right,...
                         'ihhighlight',0,...
                         'ndataoverlay',0,...
                         'iscreenwrite',1) ;
  sizer2(vucdata,paramstruct) ;


  subplot(2,2,2) ;    %  upper right, censored family
    foltit = ['n = ' num2str(n) ...
              ' full, censored data'] ;
    paramstruct = struct('iout',4,...
                         'famoltitle',foltit,...
                         'titlefontsize',18,...
                         'icensor',1,...
                         'imovie',0,...
                         'minx',left,...
                         'maxx',right,...
                         'ndataoverlay',0,...
                         'iscreenwrite',1) ;
  sizer2([vdata,vdel],paramstruct) ;
  hold on ;    %  add jitter plot
    vax = axis ;
    randht = vax(3) + (0.6 + 0.3 *vjit1) * ...
                              (vax(4) - vax(3)) ;
          %  Note, this uses same vjit1 as defined above
    plot(vucdata,randht,'g.') ;

    vjit2 = rand(n-nuc,1) ;

    randht = vax(3) + (0.6 + 0.3 * vjit2) * ...
                              (vax(4) - vax(3)) ;
          %  Note, this uses same vjit1 as defined above
    plot(vcdata,randht,'y.') ;
  hold off ;


  subplot(2,2,4) ;    %  lower right, censored SiZer
    paramstruct = struct('iout',6,...
                         'sizertitle','Censored SiZer Map',...
                         'titlefontsize',18,...
                         'icensor',1,...
                         'imovie',0,...
                         'minx',left,...
                         'maxx',right,...
                         'ndataoverlay',0,...
                         'iscreenwrite',1) ;
  sizer2([vdata,vdel],paramstruct) ;




%  Do save as .eps file
%

%  Old stuff
    vpos = get(gcf,'Position') ;
    ht2wdrat = vpos(4) / vpos(3) ;
          %  height to width ratio
    paperwd = 4 ;
          %  width of image on paper (inches)
    paperht = ht2wdrat * paperwd ;
          %  height of image on paper (inches)
          %  using this ratio keeps all labels and titles
    marginwd = (8.5 - paperwd) / 2 ;
          %  widht of left margin on paper
    marginht = 9 - paperht ;
          %  widht of bottom margin on paper
          %  leaves image 2 inches down from top
    set(gcf,'PaperPosition',[marginwd, marginht, paperwd, paperht]) ;
    set(gcf,'PaperPositionMode','auto') ;




  orient landscape ;
  pstr = ['print -depsc \Sw30\Pictures\SZHazCen\SZHazCenFig1.eps'] ;
eval(pstr) ;




