disp('Running MATLAB script file SZHazCenFig2.m') ;
%
%    Creates Figure 2 for the paper on
%    Censored, Hazard SiZer paper
%
%    Copied from CHSZeg1.m,
%    Censored Hazard SiZer, Example 1. 
%    (this is ipart = 1)



%  Generate data
%
n = 500 ;
left = -2.5 ;
right = 2.5 ;
rand('seed',93248548) ;
randn('seed',36982643) ;

vdata = randn(n,1) / 2 ;
          %  column vector of i.i.d. Gaussian(0,1/4)s
vdata = vdata + 1 * (1 - 2 * (rand(n,1) > .5)) ;
          %  add random +- 1

vdata = round(vdata * 10) / 10 ;
          %  Round to nearest 0.01





%  Set up graphics
%
close all ;
figure(1) ;
clf ;

vpos = get(gcf,'Position') ;
magfactwd = 0.6 ;
magfactht = 0.8 ;
incwd = (magfactwd - 1) * vpos(3) ;
incht = (magfactht - 1) * vpos(4) ;
vpos(1) = vpos(1) - incwd ;
vpos(2) = vpos(2) - incht ;
vpos(3) = vpos(3) + incwd ;
vpos(4) = vpos(4) + incht ;
set(gcf,'Position',vpos) ;




paramstruct = struct('iout',3,...
                     'famoltitle','Figure 2a',...
                     'sizertitle','Figure 2b',...
                     'imovie',0,...
                     'ihhighlight',0,...
                     'minx',left,...
                     'maxx',right,...
                     'iscreenwrite',1) ;

sizer2(vdata,paramstruct) ;




%  Save graph as .eps file
%
vpos = get(gcf,'Position') ;
ht2wdrat = vpos(4) / vpos(3) ;
          %  height to width ratio
paperwd = 4 ;
          %  width of image on paper (inches)
paperht = ht2wdrat * paperwd ;
          %  height of image on paper (inches)
          %  using this ratio keeps all labels and titles
marginwd = (8.5 - paperwd) / 2 ;
          %  widht of left margin on paper
marginht = 9 - paperht ;
          %  widht of bottom margin on paper
          %  leaves image 2 inches down from top
set(gcf,'PaperPosition',[marginwd, marginht, paperwd, paperht]) ;
set(gcf,'PaperPositionMode','auto') ;


  orient portrait ;
  pstr = ['print -depsc \Sw30\Pictures\SZHazCen\SZHazCenFig2.eps'] ;
eval(pstr) ;



