disp('Running MATLAB script file SZHazCenFig4.m') ;
%
%    Creates Figure 4 for the paper on
%    Censored, Hazard SiZer paper
%
%    Copied from CHSZeg1.m,
%    Censored Hazard SiZer, Example 1. 
%    (this is ipart = 3)




%  Load data
%
fid = fopen('/matlab/steve/data/device.put.dat','rt') ;
          %  'rt' is for "read only" and "text"

  [vdata,cnt] = fscanf(fid,'%f') ;

fclose(fid) ;




%  Set up graphics
%
close all ;
figure(1) ;
clf ;

vpos = get(gcf,'Position') ;
magfactwd = 1.0 ;
magfactht = 0.8 ;
incwd = (magfactwd - 1) * vpos(3) ;
incht = (magfactht - 1) * vpos(4) ;
vpos(1) = vpos(1) - incwd ;
vpos(2) = vpos(2) - incht ;
vpos(3) = vpos(3) + incwd ;
vpos(4) = vpos(4) + incht ;
set(gcf,'Position',vpos) ;




titstr = 'Device Lifetimes' ;

subplot(2,2,1) ;
  paramstruct = struct('iout',4,...
                       'famoltitle','Figure 4a',...
                       'ihazard',0,...
                       'imovie',0,...
                       'ihhighlight',0,...
                       'iscreenwrite',1) ;
sizer2(vdata,paramstruct) ;

subplot(2,2,3) ;
  paramstruct = struct('iout',6,...
                       'sizertitle','Figure 4c',...
                       'ihazard',0,...
                       'imovie',0,...
                       'ihhighlight',0,...
                       'iscreenwrite',1) ;
sizer2(vdata,paramstruct) ;

subplot(2,2,2) ;
  paramstruct = struct('iout',4,...
                       'famoltitle','Figure 4b',...
                       'ihazard',1,...
                       'imovie',0,...
                       'iscreenwrite',1) ;
sizer2(vdata,paramstruct) ;

subplot(2,2,4) ;
  paramstruct = struct('iout',6,...
                       'sizertitle','Figure 4d',...
                       'ihazard',1,...
                       'imovie',0,...
                       'iscreenwrite',1) ;
sizer2(vdata,paramstruct) ;




%  Save graph as .eps file
%
vpos = get(gcf,'Position') ;
ht2wdrat = vpos(4) / vpos(3) ;
          %  height to width ratio
paperwd = 3.5 ;
          %  width of image on paper (inches)
paperht = ht2wdrat * paperwd ;
          %  height of image on paper (inches)
          %  using this ratio keeps all labels and titles
marginwd = (8.5 - paperwd) / 2 ;
          %  widht of left margin on paper
marginht = 9 - paperht ;
          %  widht of bottom margin on paper
          %  leaves image 2 inches down from top
set(gcf,'PaperPosition',[marginwd, marginht, paperwd, paperht]) ;
set(gcf,'PaperPositionMode','auto') ;


  orient portrait ;
  pstr = ['print -depsc \Sw30\Pictures\SZHazCen\SZHazCenFig4.eps'] ;
eval(pstr) ;





