disp('Running MATLAB script file SZLenBiaFig3.m') ;
%
%    Creates Figure 3 for the paper on
%    Length Biased SiZer paper,
%    based on Jacobo de Una's Unemployment data
%


%  Read in unemployment data
%
fid = fopen(['\matlab\steve\data\paro_galicia.txt'],'rt');
data = fscanf(fid,'%f %f') ;
data = reshape(data,2,700)' ;
          %  since reshape works column wise

xdat = data(:,1) ;
vcen = data(:,2) ;



%  Set up graphics
%
close all ;
figure(1) ;
clf ;



%  Generate Main SiZer map
%
minx = 0 ;
maxx = 6 ;
bpar = 1 ;

set(gcf,'Position',[240 100 360 420]) ;

paramstruct = struct('iout',3,...
                       'imovie',0,...
                       'icensor',1, ...
                       'ihazard',1, ...
                       'ilengthb',0, ...
                       'minx',minx, ...
                       'maxx',maxx, ...
                       'bpar',bpar, ...
                       'nsh',41, ...
                       'xlabelstr','Time Unemp. (yr.)',...
                       'famoltitle','Figure 3a', ...
                       'sizertitle','Figure 3b', ...
                       'iscreenwrite',1 ...
                                                ) ;

sizer2([xdat, vcen],paramstruct) ;



%  Add highlighted kde
%
lh = -0.35 ;
h = 10^(lh) ;


subplot(2,1,1) ;
  vachil = get(gca,'Children') ;
  set(vachil(1),'MarkerSize',1) ;
  set(vachil(1),'LineWidth',1) ;
  set(vachil(1),'Marker','o') ;
  set(vachil(1),'Color','g') ;
  set(vachil(2),'MarkerSize',1) ;
  set(vachil(2),'LineWidth',1) ;
  set(vachil(2),'Marker','o') ;
  set(vachil(2),'Color','w') ;
  hold on ;
    [vkde, fxgrid] = CHkde([xdat, vcen],h,2,[minx; maxx],bpar) ;
          %  argument itype (of CHkde) is:
          %                1  when ihazard = 0 and ilengthb = 0
          %                2  when ihazard = 1 and ilengthb = 0
          %                3  when ihazard = 0 and ilengthb = 1
          %                4  when ihazard = 1 and ilengthb = 1
    plot(fxgrid,vkde,'w-','LineWidth',2) ;
  hold off ;

subplot(2,1,2) ;
  hold on ;
    plot([minx; maxx],[lh,lh],'k-') ;
  hold off ;



%  Save graph as .eps file
%
vpos = get(gcf,'Position') ;
ht2wdrat = vpos(4) / vpos(3) ;
          %  height to width ratio
paperwd = 3.5 ;
          %  width of image on paper (inches)
paperht = ht2wdrat * paperwd ;
          %  height of image on paper (inches)
          %  using this ratio keeps all labels and titles
marginwd = (8.5 - paperwd) / 2 ;
          %  widht of left margin on paper
marginht = 9 - paperht ;
          %  widht of bottom margin on paper
          %  leaves image 2 inches down from top
set(gcf,'PaperPosition',[marginwd, marginht, paperwd, paperht]) ;
set(gcf,'PaperPositionMode','auto') ;


  orient portrait ;
  pstr = ['print -depsc \Sw30\Pictures\SZLenBias\SZLenBiasFig3.eps'] ;
eval(pstr) ;




