function edf = SSfamfitlim(log10spar,n,df,ab)
%function for finding limits of Smoothing Spline FAMily FIT
%Inputs
% log10spar= log10 of candidate smoothing parameter
% n=sample size
% df = desired degrees of freedom
% ab=[a,b]=range of interest
%Output
% edf=Approximate degrees of freedom,
%     from (4.2) in Silverman (1984) JASA, 79, 584-589.
% By J. S. Marron & J.T. Zhang,   May 21, 2001

if n <= 2 ;
  disp('!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!') ;
  disp('!!!   Error from SSfamfitlim   !!!') ;
  disp('!!!   Can''t use n <= 2         !!!') ;
  disp('!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!') ;
else ;
  edf = (3:n)' ;
  edf = 10^log10spar * pi^4 * (edf - 1.5).^4 * (ab(2)-ab(1))^(-3) ;
  edf = 1 ./ (1 + edf / n) ;
  edf = sum(edf) ;
  edf = edf + 2 ;
  edf = log(edf) - log(df) ;
end ;

