disp('Running MATLAB script file SiZerDist1Fig12.m') ;
%
%    For Making Figure 12
%    in the Advanced Distribution Theory for SiZer paper
%
%
%    Copied from: SiZerSimul2power.m via SiZerDist1Fig10.m
%
%    For investigating power (using standard test bed examples)
%    of improved SiZer methods
%
%    Copied from sizerSMtest.m
%
%    FOR DEVELOPMENT AND TESTING OF MATLAB FUNCTION sizerSM,
%    Default version of SiZer,


%vitest == [15] ;    %  then do Flow cytometry examples 

%iout = 1 ;    %  1 - 4 panel SiZer plot, Regular, Hsing-R, H-Bonf, H-Global

addpath 'D:\Research\SiZer\simul';
%path

fighand = figure(1) ;
clf ;




idat = 3 ;            %  1 - ELU
                      %  2 - LNU
                      %  3 - TH
                      
icol = 8 ;           % possible values 1:14 regardless of idat



preinstr = '\Research\Bioinf\FlowCyt\' ;

if idat == 1 ; 
  infilestr = 'FloCytELU.txt' ;
  savestr = 'ELU' ;
elseif idat == 2 ; 
  infilestr = 'FloCytLNU.txt' ;
  savestr = 'LNU' ;
elseif idat == 3 ; 
  infilestr = 'FloCytTH.txt' ;
  savestr = 'TH' ;
end ;


xstr = 'channel' ;
ystr = 'sqrt(counts)' ;


fid = fopen([preinstr infilestr],'rt');
mdata = fscanf(fid,'%f') ;
mdata = reshape(mdata,14,256)' ;
          %  since reshape works column wise
mdata = sqrt(mdata) ;




colstr = num2str(icol) ;
titstr = ['Flow Cytometry, ' savestr ', col. ' colstr] ;

data = [(1:256)',mdata(:,icol)] ;





subplot(4,1,1) ;    %  Regular SiZer 
paramstruct = struct('sizertitle',['Figure 12a'],...
                     'iout',6, ...
                     'nsh',21, ...
                     'imovie',0, ...
                     'ishoweffwind',0, ...
                     'hhighlight',0, ...
                     'iscreenwrite',1) ;

sizerSM(data,paramstruct) ;
ylabel('') ;
set(gca,'XtickLabel',[]) ;



subplot(4,1,2) ;    %  Hsing R SiZer 

disp('        Working on Hsing Row-Wise SiZer') ;
paramstruct = struct('titlestr',['Figure 12b'],...
                     'ibdryadj',0, ...
                     'simflag',2) ;

  %  Note 'ibdryadj',0 is DIFFERENT from the 2 used in sims
  %  simflag is:
  %       1  -  Use old Row-wise Simultaneous C.I.'s
  %       2 (or not specified) - Use Row-wise based on Hsing at al. (1996)
  %       3  -  Use global adjustment (sum independent blocks calculated as in 2)
  %       4  -  Use global adjustment based on Bonferoni and Hsing at al. (1996).

sz2SMsim(data,paramstruct) ;
set(gca,'XtickLabel',[]) ;


subplot(4,1,3) ;    %  H-Bonf SiZer 
disp('        Working on Hsing Bonferroni SiZer') ;
paramstruct = struct('titlestr',['Figure 12c'],...
                     'ibdryadj',0, ...
                     'simflag',4) ;
 
  %  Note 'ibdryadj',0 is DIFFERENT from the 2 used in sims
  %  simflag is:
  %       4  -  Use global adjustment based on Bonferoni and Hsing at al. (1996).

sz2SMsim(data,paramstruct) ;
set(gca,'XtickLabel',[]) ;


subplot(4,1,4) ;    %  H-GLobal SiZer 
disp('        Working on Hsing Global SiZer') ;
paramstruct = struct('titlestr',['Figure 12d'],...
                     'ibdryadj',0, ...
                     'simflag',3) ;

  %  simflag is:
  %       3  -  Use global adjustment (sum independent blocks calculated as in 2)

sz2SMsim(data,paramstruct) ;





%subplot(2,1,1) ;
%hold on ;
%
%  plot(xgrid,m,'k-','LineWidth',2) ;
%
%hold off ;



pstr = 'SiZerDist1Fig12' ;

  orient portrait ;
  set(gcf,'PaperSize',[6.0, 6.0]) ; 
  set(gcf,'PaperPosition',[0.25, 0.25, 5.5, 5.5]) ; 
print('-dpsc', [pstr '.ps']) ;

